/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;

public class GetBotVersionsPublisher
implements SdkPublisher<GetBotVersionsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBotVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBotVersionsPublisher(LexModelBuildingAsyncClient client, GetBotVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBotVersionsPublisher(LexModelBuildingAsyncClient client, GetBotVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBotVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBotVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetBotVersionsPublisher resume(GetBotVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotVersionsPublisher(this.client, (GetBotVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetBotVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetBotVersionsResponseFetcher
    implements AsyncPageFetcher<GetBotVersionsResponse> {
        private GetBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetBotVersionsResponse> nextPage(GetBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetBotVersionsPublisher.this.client.getBotVersions(GetBotVersionsPublisher.this.firstRequest);
            }
            return GetBotVersionsPublisher.this.client.getBotVersions((GetBotVersionsRequest)((Object)GetBotVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

