/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;

public class GetIntentVersionsIterable
implements SdkIterable<GetIntentVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIntentVersionsIterable(LexModelBuildingClient client, GetIntentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIntentVersionsResponseFetcher();
    }

    public Iterator<GetIntentVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetIntentVersionsIterable resume(GetIntentVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetIntentVersionsIterable(this.client, (GetIntentVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetIntentVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetIntentVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetIntentVersionsResponseFetcher
    implements SyncPageFetcher<GetIntentVersionsResponse> {
        private GetIntentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetIntentVersionsResponse nextPage(GetIntentVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentVersionsIterable.this.client.getIntentVersions(GetIntentVersionsIterable.this.firstRequest);
            }
            return GetIntentVersionsIterable.this.client.getIntentVersions((GetIntentVersionsRequest)((Object)GetIntentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

