/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;

public class GetIntentsIterable
implements SdkIterable<GetIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIntentsIterable(LexModelBuildingClient client, GetIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIntentsResponseFetcher();
    }

    public Iterator<GetIntentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetIntentsIterable resume(GetIntentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetIntentsIterable(this.client, (GetIntentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetIntentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetIntentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetIntentsResponseFetcher
    implements SyncPageFetcher<GetIntentsResponse> {
        private GetIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetIntentsResponse nextPage(GetIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentsIterable.this.client.getIntents(GetIntentsIterable.this.firstRequest);
            }
            return GetIntentsIterable.this.client.getIntents((GetIntentsRequest)((Object)GetIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

