/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;

public class GetIntentsPublisher
implements SdkPublisher<GetIntentsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetIntentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIntentsPublisher(LexModelBuildingAsyncClient client, GetIntentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIntentsPublisher(LexModelBuildingAsyncClient client, GetIntentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIntentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIntentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetIntentsPublisher resume(GetIntentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetIntentsPublisher(this.client, (GetIntentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetIntentsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetIntentsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetIntentsResponseFetcher
    implements AsyncPageFetcher<GetIntentsResponse> {
        private GetIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetIntentsResponse> nextPage(GetIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentsPublisher.this.client.getIntents(GetIntentsPublisher.this.firstRequest);
            }
            return GetIntentsPublisher.this.client.getIntents((GetIntentsRequest)((Object)GetIntentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

