/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotChannelAssociation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BotChannelAssociationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> BOTALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botAlias").isBinary(false).build();
    private static final MarshallingInfo<String> BOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botName").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Map> BOTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botConfiguration").isBinary(false).build();
    private static final BotChannelAssociationMarshaller INSTANCE = new BotChannelAssociationMarshaller();

    private BotChannelAssociationMarshaller() {
    }

    public static BotChannelAssociationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BotChannelAssociation botChannelAssociation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)botChannelAssociation, (String)"botChannelAssociation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)botChannelAssociation.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)botChannelAssociation.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)botChannelAssociation.botAlias(), BOTALIAS_BINDING);
            protocolMarshaller.marshall((Object)botChannelAssociation.botName(), BOTNAME_BINDING);
            protocolMarshaller.marshall((Object)botChannelAssociation.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)botChannelAssociation.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(botChannelAssociation.botConfiguration(), BOTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

