/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IntentMarshaller {
    private static final MarshallingInfo<String> INTENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intentName").isBinary(false).build();
    private static final MarshallingInfo<String> INTENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intentVersion").isBinary(false).build();
    private static final IntentMarshaller INSTANCE = new IntentMarshaller();

    private IntentMarshaller() {
    }

    public static IntentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Intent intent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)intent, (String)"intent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)intent.intentName(), INTENTNAME_BINDING);
            protocolMarshaller.marshall((Object)intent.intentVersion(), INTENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

