/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotAliasRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<DeleteBotAliasRequest.Builder, DeleteBotAliasRequest> {
    private final String name;

    private final String botName;

    private DeleteBotAliasRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.botName = builder.botName;
    }

    /**
     * <p>
     * The name of the alias to delete. The name is case sensitive.
     * </p>
     * 
     * @return The name of the alias to delete. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the bot that the alias points to.
     * </p>
     * 
     * @return The name of the bot that the alias points to.
     */
    public String botName() {
        return botName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotAliasRequest)) {
            return false;
        }
        DeleteBotAliasRequest other = (DeleteBotAliasRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(botName(), other.botName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteBotAliasRequest").add("Name", name()).add("BotName", botName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, DeleteBotAliasRequest> {
        /**
         * <p>
         * The name of the alias to delete. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the alias to delete. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the bot that the alias points to.
         * </p>
         * 
         * @param botName
         *        The name of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String botName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotAliasRequest model) {
            super(model);
            name(model.name);
            botName(model.botName);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBotAliasRequest build() {
            return new DeleteBotAliasRequest(this);
        }
    }
}
