/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBuiltinIntentRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetBuiltinIntentRequest.Builder, GetBuiltinIntentRequest> {
    private final String signature;

    private GetBuiltinIntentRequest(BuilderImpl builder) {
        super(builder);
        this.signature = builder.signature;
    }

    /**
     * <p>
     * The unique identifier for a built-in intent. To find the signature for an intent, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The unique identifier for a built-in intent. To find the signature for an intent, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentRequest)) {
            return false;
        }
        GetBuiltinIntentRequest other = (GetBuiltinIntentRequest) obj;
        return Objects.equals(signature(), other.signature());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinIntentRequest").add("Signature", signature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetBuiltinIntentRequest> {
        /**
         * <p>
         * The unique identifier for a built-in intent. To find the signature for an intent, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param signature
         *        The unique identifier for a built-in intent. To find the signature for an intent, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentRequest model) {
            super(model);
            signature(model.signature);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBuiltinIntentRequest build() {
            return new GetBuiltinIntentRequest(this);
        }
    }
}
