/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntentsRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetIntentsRequest.Builder, GetIntentsRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private GetIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token
     * in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of intents. If the response to this API call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the
     *         pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of intents to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of intents to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For
     * example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in intent names. An intent will be returned if any part of its name matches the
     *         substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentsRequest)) {
            return false;
        }
        GetIntentsRequest other = (GetIntentsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIntentsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("NameContains", nameContains()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetIntentsRequest> {
        /**
         * <p>
         * A pagination token that fetches the next page of intents. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of intents. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of intents to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of intents to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Substring to match in intent names. An intent will be returned if any part of its name matches the substring.
         * For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param nameContains
         *        Substring to match in intent names. An intent will be returned if any part of its name matches the
         *        substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIntentsRequest build() {
            return new GetIntentsRequest(this);
        }
    }
}
