/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSlotTypesResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetSlotTypesResponse.Builder, GetSlotTypesResponse> {
    private final List<SlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
     * version, and a description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects, one for each slot type, that provides information such as the name of the slot type,
     *         the version, and a description.
     */
    public List<SlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of slot types.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of slot types.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypesResponse)) {
            return false;
        }
        GetSlotTypesResponse other = (GetSlotTypesResponse) obj;
        return Objects.equals(slotTypes(), other.slotTypes()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSlotTypesResponse").add("SlotTypes", slotTypes()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypes":
            return Optional.ofNullable(clazz.cast(slotTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetSlotTypesResponse> {
        /**
         * <p>
         * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
         * version, and a description.
         * </p>
         * 
         * @param slotTypes
         *        An array of objects, one for each slot type, that provides information such as the name of the slot
         *        type, the version, and a description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<SlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
         * version, and a description.
         * </p>
         * 
         * @param slotTypes
         *        An array of objects, one for each slot type, that provides information such as the name of the slot
         *        type, the version, and a description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(SlotTypeMetadata... slotTypes);

        /**
         * <p>
         * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
         * version, and a description.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<SlotTypeMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #slotTypes(List<SlotTypeMetadata>)}.
         * 
         * @param slotTypes
         *        a consumer that will call methods on {@link List<SlotTypeMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypes(List<SlotTypeMetadata>)
         */
        Builder slotTypes(Consumer<SlotTypeMetadata.Builder>... slotTypes);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of slot types.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<SlotTypeMetadata> slotTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypesResponse model) {
            super(model);
            slotTypes(model.slotTypes);
            nextToken(model.nextToken);
        }

        public final Collection<SlotTypeMetadata.Builder> getSlotTypes() {
            return slotTypes != null ? slotTypes.stream().map(SlotTypeMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(SlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(Consumer<SlotTypeMetadata.Builder>... slotTypes) {
            slotTypes(Stream.of(slotTypes).map(c -> SlotTypeMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypes(Collection<SlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSlotTypesResponse build() {
            return new GetSlotTypesResponse(this);
        }
    }
}
