/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSlotTypeResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<PutSlotTypeResponse.Builder, PutSlotTypeResponse> {
    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String version;

    private final String checksum;

    private final String valueSelectionStrategy;

    private PutSlotTypeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
    }

    /**
     * <p>
     * The name of the slot type.
     * </p>
     * 
     * @return The name of the slot type.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     */
    public List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * The date that the slot type was updated. When you create a slot type, the creation date and last update date are
     * the same.
     * </p>
     * 
     * @return The date that the slot type was updated. When you create a slot type, the creation date and last update
     *         date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the slot type was created.
     * </p>
     * 
     * @return The date that the slot type was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>.
     * </p>
     * 
     * @return The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the <code>$LATEST</code> version of the slot type.
     * </p>
     * 
     * @return Checksum of the <code>$LATEST</code> version of the slot type.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     * <a>PutSlotType</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more
     *         information, see <a>PutSlotType</a>.
     * @see SlotValueSelectionStrategy
     */
    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(valueSelectionStrategy);
    }

    /**
     * <p>
     * The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information, see
     * <a>PutSlotType</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more
     *         information, see <a>PutSlotType</a>.
     * @see SlotValueSelectionStrategy
     */
    public String valueSelectionStrategyAsString() {
        return valueSelectionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeResponse)) {
            return false;
        }
        PutSlotTypeResponse other = (PutSlotTypeResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(enumerationValues(), other.enumerationValues())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(version(), other.version())
                && Objects.equals(checksum(), other.checksum())
                && Objects.equals(valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("PutSlotTypeResponse").add("Name", name()).add("Description", description())
                .add("EnumerationValues", enumerationValues()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Checksum", checksum())
                .add("ValueSelectionStrategy", valueSelectionStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enumerationValues":
            return Optional.ofNullable(clazz.cast(enumerationValues()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "valueSelectionStrategy":
            return Optional.ofNullable(clazz.cast(valueSelectionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, PutSlotTypeResponse> {
        /**
         * <p>
         * The name of the slot type.
         * </p>
         * 
         * @param name
         *        The name of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnumerationValue>.Builder} avoiding the
         * need to create one manually via {@link List<EnumerationValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnumerationValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #enumerationValues(List<EnumerationValue>)}.
         * 
         * @param enumerationValues
         *        a consumer that will call methods on {@link List<EnumerationValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumerationValues(List<EnumerationValue>)
         */
        Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues);

        /**
         * <p>
         * The date that the slot type was updated. When you create a slot type, the creation date and last update date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the slot type was updated. When you create a slot type, the creation date and last
         *        update date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the slot type was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the slot type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>.
         * </p>
         * 
         * @param version
         *        The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the <code>$LATEST</code> version of the slot type.
         * </p>
         * 
         * @param checksum
         *        Checksum of the <code>$LATEST</code> version of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information,
         * see <a>PutSlotType</a>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more
         *        information, see <a>PutSlotType</a>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(String valueSelectionStrategy);

        /**
         * <p>
         * The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information,
         * see <a>PutSlotType</a>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more
         *        information, see <a>PutSlotType</a>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String version;

        private String checksum;

        private String valueSelectionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            enumerationValues(model.enumerationValues);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            version(model.version);
            checksum(model.checksum);
            valueSelectionStrategy(model.valueSelectionStrategy);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return enumerationValues != null ? enumerationValues.stream().map(EnumerationValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues) {
            enumerationValues(Stream.of(enumerationValues).map(c -> EnumerationValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategy() {
            return valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        @Override
        public PutSlotTypeResponse build() {
            return new PutSlotTypeResponse(this);
        }
    }
}
