/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBotRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetBotRequest> {
    private final String name;
    private final String versionOrAlias;

    private GetBotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionOrAlias = builder.versionOrAlias;
    }

    public String name() {
        return this.name;
    }

    public String versionOrAlias() {
        return this.versionOrAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionOrAlias());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotRequest)) {
            return false;
        }
        GetBotRequest other = (GetBotRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.versionOrAlias(), other.versionOrAlias());
    }

    public String toString() {
        return ToString.builder((String)"GetBotRequest").add("Name", (Object)this.name()).add("VersionOrAlias", (Object)this.versionOrAlias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionOrAlias": {
                return Optional.ofNullable(clazz.cast(this.versionOrAlias()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String versionOrAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotRequest model) {
            super(model);
            this.name(model.name);
            this.versionOrAlias(model.versionOrAlias);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionOrAlias() {
            return this.versionOrAlias;
        }

        @Override
        public final Builder versionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
            return this;
        }

        public final void setVersionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBotRequest build() {
            return new GetBotRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, GetBotRequest> {
        public Builder name(String var1);

        public Builder versionOrAlias(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

