/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadataListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBotsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBotsResponse> {
    private final List<BotMetadata> bots;
    private final String nextToken;

    private GetBotsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    public List<BotMetadata> bots() {
        return this.bots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotsResponse)) {
            return false;
        }
        GetBotsResponse other = (GetBotsResponse)((Object)obj);
        return Objects.equals(this.bots(), other.bots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetBotsResponse").add("Bots", this.bots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bots": {
                return Optional.ofNullable(clazz.cast(this.bots()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<BotMetadata> bots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotsResponse model) {
            super(model);
            this.bots(model.bots);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotMetadata.Builder> getBots() {
            return this.bots != null ? (Collection)this.bots.stream().map(BotMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata ... bots) {
            this.bots(Arrays.asList(bots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(Consumer<BotMetadata.Builder> ... bots) {
            this.bots(Stream.of(bots).map(c -> (BotMetadata)((BotMetadata.Builder)BotMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotsResponse build() {
            return new GetBotsResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetBotsResponse> {
        public Builder bots(Collection<BotMetadata> var1);

        public Builder bots(BotMetadata ... var1);

        public Builder bots(Consumer<BotMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

