/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBuiltinIntentsRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetBuiltinIntentsRequest> {
    private final String locale;
    private final String signatureContains;
    private final String nextToken;
    private final Integer maxResults;

    private GetBuiltinIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    public String signatureContains() {
        return this.signatureContains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsRequest)) {
            return false;
        }
        GetBuiltinIntentsRequest other = (GetBuiltinIntentsRequest)((Object)obj);
        return Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.signatureContains(), other.signatureContains()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetBuiltinIntentsRequest").add("Locale", (Object)this.localeAsString()).add("SignatureContains", (Object)this.signatureContains()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "signatureContains": {
                return Optional.ofNullable(clazz.cast(this.signatureContains()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String locale;
        private String signatureContains;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsRequest model) {
            super(model);
            this.locale(model.locale);
            this.signatureContains(model.signatureContains);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return this.signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBuiltinIntentsRequest build() {
            return new GetBuiltinIntentsRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, GetBuiltinIntentsRequest> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder signatureContains(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

