/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentMetadataListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntentsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetIntentsResponse> {
    private final List<IntentMetadata> intents;
    private final String nextToken;

    private GetIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    public List<IntentMetadata> intents() {
        return this.intents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentsResponse)) {
            return false;
        }
        GetIntentsResponse other = (GetIntentsResponse)((Object)obj);
        return Objects.equals(this.intents(), other.intents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetIntentsResponse").add("Intents", this.intents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intents": {
                return Optional.ofNullable(clazz.cast(this.intents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<IntentMetadata> intents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentsResponse model) {
            super(model);
            this.intents(model.intents);
            this.nextToken(model.nextToken);
        }

        public final Collection<IntentMetadata.Builder> getIntents() {
            return this.intents != null ? (Collection)this.intents.stream().map(IntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<IntentMetadata> intents) {
            this.intents = IntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(IntentMetadata ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<IntentMetadata.Builder> ... intents) {
            this.intents(Stream.of(intents).map(c -> (IntentMetadata)((IntentMetadata.Builder)IntentMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<IntentMetadata.BuilderImpl> intents) {
            this.intents = IntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetIntentsResponse build() {
            return new GetIntentsResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetIntentsResponse> {
        public Builder intents(Collection<IntentMetadata> var1);

        public Builder intents(IntentMetadata ... var1);

        public Builder intents(Consumer<IntentMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

