/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.Message;
import software.amazon.awssdk.services.lexmodelbuilding.model.MessageListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.StatementMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statement
implements StructuredPojo,
ToCopyableBuilder<Builder, Statement> {
    private final List<Message> messages;
    private final String responseCard;

    private Statement(BuilderImpl builder) {
        this.messages = builder.messages;
        this.responseCard = builder.responseCard;
    }

    public List<Message> messages() {
        return this.messages;
    }

    public String responseCard() {
        return this.responseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCard());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        return Objects.equals(this.messages(), other.messages()) && Objects.equals(this.responseCard(), other.responseCard());
    }

    public String toString() {
        return ToString.builder((String)"Statement").add("Messages", this.messages()).add("ResponseCard", (Object)this.responseCard()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "responseCard": {
                return Optional.ofNullable(clazz.cast(this.responseCard()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.messages(model.messages);
            this.responseCard(model.responseCard);
        }

        public final Collection<Message.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(Message::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessageListCopier.copyFromBuilder(messages);
        }

        public final String getResponseCard() {
            return this.responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        public Statement build() {
            return new Statement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Statement> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder responseCard(String var1);
    }
}

