/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;

public class GetBuiltinSlotTypesPublisher
implements SdkPublisher<GetBuiltinSlotTypesResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBuiltinSlotTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBuiltinSlotTypesPublisher(LexModelBuildingAsyncClient client, GetBuiltinSlotTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBuiltinSlotTypesPublisher(LexModelBuildingAsyncClient client, GetBuiltinSlotTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBuiltinSlotTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBuiltinSlotTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetBuiltinSlotTypesPublisher resume(GetBuiltinSlotTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBuiltinSlotTypesPublisher(this.client, (GetBuiltinSlotTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBuiltinSlotTypesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetBuiltinSlotTypesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetBuiltinSlotTypesResponseFetcher
    implements AsyncPageFetcher<GetBuiltinSlotTypesResponse> {
        private GetBuiltinSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinSlotTypesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<GetBuiltinSlotTypesResponse> nextPage(GetBuiltinSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinSlotTypesPublisher.this.client.getBuiltinSlotTypes(GetBuiltinSlotTypesPublisher.this.firstRequest);
            }
            return GetBuiltinSlotTypesPublisher.this.client.getBuiltinSlotTypes((GetBuiltinSlotTypesRequest)((Object)GetBuiltinSlotTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

