/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;

public class GetSlotTypesIterable
implements SdkIterable<GetSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSlotTypesIterable(LexModelBuildingClient client, GetSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSlotTypesResponseFetcher();
    }

    public Iterator<GetSlotTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetSlotTypesIterable resume(GetSlotTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetSlotTypesIterable(this.client, (GetSlotTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetSlotTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetSlotTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetSlotTypesResponseFetcher
    implements SyncPageFetcher<GetSlotTypesResponse> {
        private GetSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetSlotTypesResponse nextPage(GetSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypesIterable.this.client.getSlotTypes(GetSlotTypesIterable.this.firstRequest);
            }
            return GetSlotTypesIterable.this.client.getSlotTypes((GetSlotTypesRequest)((Object)GetSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

