/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BuiltinIntentMetadataMarshaller {
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signature").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDLOCALES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedLocales").isBinary(false).build();
    private static final BuiltinIntentMetadataMarshaller INSTANCE = new BuiltinIntentMetadataMarshaller();

    private BuiltinIntentMetadataMarshaller() {
    }

    public static BuiltinIntentMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BuiltinIntentMetadata builtinIntentMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)builtinIntentMetadata, (String)"builtinIntentMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)builtinIntentMetadata.signature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall(builtinIntentMetadata.supportedLocalesAsStrings(), SUPPORTEDLOCALES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

