/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PromptMarshaller {
    private static final MarshallingInfo<List> MESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messages").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXATTEMPTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxAttempts").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONSECARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseCard").isBinary(false).build();
    private static final PromptMarshaller INSTANCE = new PromptMarshaller();

    private PromptMarshaller() {
    }

    public static PromptMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Prompt prompt, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)prompt, (String)"prompt");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(prompt.messages(), MESSAGES_BINDING);
            protocolMarshaller.marshall((Object)prompt.maxAttempts(), MAXATTEMPTS_BINDING);
            protocolMarshaller.marshall((Object)prompt.responseCard(), RESPONSECARD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

