/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Slot;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SlotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> SLOTCONSTRAINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slotConstraint").isBinary(false).build();
    private static final MarshallingInfo<String> SLOTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slotType").isBinary(false).build();
    private static final MarshallingInfo<String> SLOTTYPEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slotTypeVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VALUEELICITATIONPROMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("valueElicitationPrompt").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("priority").isBinary(false).build();
    private static final MarshallingInfo<List> SAMPLEUTTERANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleUtterances").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONSECARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseCard").isBinary(false).build();
    private static final SlotMarshaller INSTANCE = new SlotMarshaller();

    private SlotMarshaller() {
    }

    public static SlotMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Slot slot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)slot, (String)"slot");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)slot.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)slot.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)slot.slotConstraintAsString(), SLOTCONSTRAINT_BINDING);
            protocolMarshaller.marshall((Object)slot.slotType(), SLOTTYPE_BINDING);
            protocolMarshaller.marshall((Object)slot.slotTypeVersion(), SLOTTYPEVERSION_BINDING);
            protocolMarshaller.marshall((Object)slot.valueElicitationPrompt(), VALUEELICITATIONPROMPT_BINDING);
            protocolMarshaller.marshall((Object)slot.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall(slot.sampleUtterances(), SAMPLEUTTERANCES_BINDING);
            protocolMarshaller.marshall((Object)slot.responseCard(), RESPONSECARD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

