/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceList;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UtteranceListMarshaller {
    private static final MarshallingInfo<String> BOTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botVersion").isBinary(false).build();
    private static final MarshallingInfo<List> UTTERANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utterances").isBinary(false).build();
    private static final UtteranceListMarshaller INSTANCE = new UtteranceListMarshaller();

    private UtteranceListMarshaller() {
    }

    public static UtteranceListMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UtteranceList utteranceList, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)utteranceList, (String)"utteranceList");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)utteranceList.botVersion(), BOTVERSION_BINDING);
            protocolMarshaller.marshall(utteranceList.utterances(), UTTERANCES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

