/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BotAliasMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a bot alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotAliasMetadata implements StructuredPojo, ToCopyableBuilder<BotAliasMetadata.Builder, BotAliasMetadata> {
    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String checksum;

    private BotAliasMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot alias.
     * </p>
     * 
     * @return A description of the bot alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the Amazon Lex bot to which the alias points.
     * </p>
     * 
     * @return The version of the Amazon Lex bot to which the alias points.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot to which the alias points.
     * </p>
     * 
     * @return The name of the bot to which the alias points.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the bot alias was updated. When you create a resource, the creation date and last updated date are
     * the same.
     * </p>
     * 
     * @return The date that the bot alias was updated. When you create a resource, the creation date and last updated
     *         date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot alias was created.
     * </p>
     * 
     * @return The date that the bot alias was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Checksum of the bot alias.
     * </p>
     * 
     * @return Checksum of the bot alias.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasMetadata)) {
            return false;
        }
        BotAliasMetadata other = (BotAliasMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(botName(), other.botName())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(checksum(), other.checksum());
    }

    @Override
    public String toString() {
        return ToString.builder("BotAliasMetadata").add("Name", name()).add("Description", description())
                .add("BotVersion", botVersion()).add("BotName", botName()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("Checksum", checksum()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BotAliasMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BotAliasMetadata> {
        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param name
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot alias.
         * </p>
         * 
         * @param description
         *        A description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the Amazon Lex bot to which the alias points.
         * </p>
         * 
         * @param botVersion
         *        The version of the Amazon Lex bot to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot to which the alias points.
         * </p>
         * 
         * @param botName
         *        The name of the bot to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the bot alias was updated. When you create a resource, the creation date and last updated date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot alias was updated. When you create a resource, the creation date and last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot alias was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Checksum of the bot alias.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasMetadata model) {
            name(model.name);
            description(model.description);
            botVersion(model.botVersion);
            botName(model.botName);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            checksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public BotAliasMetadata build() {
            return new BotAliasMetadata(this);
        }
    }
}
