/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntentsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetIntentsResponse.Builder, GetIntentsResponse> {
    private final List<IntentMetadata> intents;

    private final String nextToken;

    private GetIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     */
    public List<IntentMetadata> intents() {
        return intents;
    }

    /**
     * <p>
     * If the response is truncated, the response includes a pagination token that you can specify in your next request
     * to fetch the next page of intents.
     * </p>
     * 
     * @return If the response is truncated, the response includes a pagination token that you can specify in your next
     *         request to fetch the next page of intents.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentsResponse)) {
            return false;
        }
        GetIntentsResponse other = (GetIntentsResponse) obj;
        return Objects.equals(intents(), other.intents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIntentsResponse").add("Intents", intents()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intents":
            return Optional.ofNullable(clazz.cast(intents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetIntentsResponse> {
        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<IntentMetadata> intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(IntentMetadata... intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntentMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<IntentMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntentMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #intents(List<IntentMetadata>)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link List<IntentMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(List<IntentMetadata>)
         */
        Builder intents(Consumer<IntentMetadata.Builder>... intents);

        /**
         * <p>
         * If the response is truncated, the response includes a pagination token that you can specify in your next
         * request to fetch the next page of intents.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the response includes a pagination token that you can specify in your
         *        next request to fetch the next page of intents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<IntentMetadata> intents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentsResponse model) {
            super(model);
            intents(model.intents);
            nextToken(model.nextToken);
        }

        public final Collection<IntentMetadata.Builder> getIntents() {
            return intents != null ? intents.stream().map(IntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<IntentMetadata> intents) {
            this.intents = IntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(IntentMetadata... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<IntentMetadata.Builder>... intents) {
            intents(Stream.of(intents).map(c -> IntentMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<IntentMetadata.BuilderImpl> intents) {
            this.intents = IntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetIntentsResponse build() {
            return new GetIntentsResponse(this);
        }
    }
}
