/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.MessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message object that provides the message text and its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements StructuredPojo, ToCopyableBuilder<Message.Builder, Message> {
    private final String contentType;

    private final String content;

    private final Integer groupNumber;

    private Message(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.groupNumber = builder.groupNumber;
    }

    /**
     * <p>
     * The content type of the message string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the message string.
     * @see ContentType
     */
    public ContentType contentType() {
        return ContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The content type of the message string.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the message string.
     * @see ContentType
     */
    public String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The text of the message.
     * </p>
     * 
     * @return The text of the message.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon Lex
     * returns one message from each group in the response.
     * </p>
     * 
     * @return Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon
     *         Lex returns one message from each group in the response.
     */
    public Integer groupNumber() {
        return groupNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(groupNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(content(), other.content())
                && Objects.equals(groupNumber(), other.groupNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("Message").add("ContentType", contentTypeAsString()).add("Content", content())
                .add("GroupNumber", groupNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "groupNumber":
            return Optional.ofNullable(clazz.cast(groupNumber()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The content type of the message string.
         * </p>
         * 
         * @param contentType
         *        The content type of the message string.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content type of the message string.
         * </p>
         * 
         * @param contentType
         *        The content type of the message string.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(ContentType contentType);

        /**
         * <p>
         * The text of the message.
         * </p>
         * 
         * @param content
         *        The text of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon Lex
         * returns one message from each group in the response.
         * </p>
         * 
         * @param groupNumber
         *        Identifies the message group that the message belongs to. When a group is assigned to a message,
         *        Amazon Lex returns one message from each group in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNumber(Integer groupNumber);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private String content;

        private Integer groupNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            contentType(model.contentType);
            content(model.content);
            groupNumber(model.groupNumber);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final Integer getGroupNumber() {
            return groupNumber;
        }

        @Override
        public final Builder groupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public final void setGroupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
        }

        @Override
        public Message build() {
            return new Message(this);
        }
    }
}
