/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBotResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<PutBotResponse.Builder, PutBotResponse> {
    private final String name;

    private final String description;

    private final List<Intent> intents;

    private final Prompt clarificationPrompt;

    private final Statement abortStatement;

    private final String status;

    private final String failureReason;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final Integer idleSessionTTLInSeconds;

    private final String voiceId;

    private final String checksum;

    private final String version;

    private final String locale;

    private final Boolean childDirected;

    private final Boolean createVersion;

    private PutBotResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.version = builder.version;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
        this.createVersion = builder.createVersion;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
     */
    public List<Intent> intents() {
        return intents;
    }

    /**
     * <p>
     * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
     *         <a>PutBot</a>.
     */
    public Prompt clarificationPrompt() {
        return clarificationPrompt;
    }

    /**
     * <p>
     * The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.
     * </p>
     * 
     * @return The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.
     */
    public Statement abortStatement() {
        return abortStatement;
    }

    /**
     * <p>
     * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex
     * sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets
     * <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code>
     * to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response
     * element.
     * </p>
     * <p>
     * When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
     * <code>NOT BUILT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
     *         Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex
     *         builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot,
     *         Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure
     *         in the <code>failureReason</code> response element. </p>
     *         <p>
     *         When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
     *         <code>NOT BUILT</code>.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex
     * sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets
     * <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code>
     * to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response
     * element.
     * </p>
     * <p>
     * When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
     * <code>NOT BUILT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
     *         Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex
     *         builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot,
     *         Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure
     *         in the <code>failureReason</code> response element. </p>
     *         <p>
     *         When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
     *         <code>NOT BUILT</code>.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
     *         bot.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date that the bot was updated. When you create a resource, the creation date and last updated date are the
     * same.
     * </p>
     * 
     * @return The date that the bot was updated. When you create a resource, the creation date and last updated date
     *         are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot was created.
     * </p>
     * 
     * @return The date that the bot was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more
     *         information, see <a>PutBot</a>.
     */
    public Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see
     * <a>PutBot</a>.
     * </p>
     * 
     * @return The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information,
     *         see <a>PutBot</a>.
     */
    public String voiceId() {
        return voiceId;
    }

    /**
     * <p>
     * Checksum of the bot that you created.
     * </p>
     * 
     * @return Checksum of the bot that you created.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
     * </p>
     * 
     * @return The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The target locale for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The target locale for the bot.
     * @see Locale
     */
    public Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The target locale for the bot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The target locale for the bot.
     * @see Locale
     */
    public String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of
     * Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in
     * part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
     * <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code>
     * in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website,
     * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
     * subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
     * use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted,
     * in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the
     * <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a
     * website, program, or other application that is directed or targeted, in whole or in part, to children under age
     * 13 and subject to COPPA.
     * </p>
     * <p>
     * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
     * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
     * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
     * directed or targeted, in whole or in part, to children under age 13, see the <a
     * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     * </p>
     * 
     * @return For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your
     *         use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in
     *         whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act
     *         (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By
     *         specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon
     *         Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole
     *         or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the
     *         <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a
     *         website, program, or other application that is directed or targeted, in whole or in part, to children
     *         under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code>
     *         field that does not accurately reflect whether your use of Amazon Lex is related to a website, program,
     *         or other application that is directed or targeted, in whole or in part, to children under age 13 and
     *         subject to COPPA.</p>
     *         <p>
     *         If your use of Amazon Lex relates to a website, program, or other application that is directed in whole
     *         or in part, to children under age 13, you must obtain any required verifiable parental consent under
     *         COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other
     *         applications that are directed or targeted, in whole or in part, to children under age 13, see the <a
     *         href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     */
    public Boolean childDirected() {
        return childDirected;
    }

    /**
     * Returns the value of the CreateVersion property for this object.
     * 
     * @return The value of the CreateVersion property for this object.
     */
    public Boolean createVersion() {
        return createVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(childDirected());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotResponse)) {
            return false;
        }
        PutBotResponse other = (PutBotResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(intents(), other.intents())
                && Objects.equals(clarificationPrompt(), other.clarificationPrompt())
                && Objects.equals(abortStatement(), other.abortStatement())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(voiceId(), other.voiceId()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(version(), other.version()) && Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(childDirected(), other.childDirected())
                && Objects.equals(createVersion(), other.createVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBotResponse").add("Name", name()).add("Description", description()).add("Intents", intents())
                .add("ClarificationPrompt", clarificationPrompt()).add("AbortStatement", abortStatement())
                .add("Status", statusAsString()).add("FailureReason", failureReason()).add("LastUpdatedDate", lastUpdatedDate())
                .add("CreatedDate", createdDate()).add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("VoiceId", voiceId()).add("Checksum", checksum()).add("Version", version()).add("Locale", localeAsString())
                .add("ChildDirected", childDirected()).add("CreateVersion", createVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "intents":
            return Optional.ofNullable(clazz.cast(intents()));
        case "clarificationPrompt":
            return Optional.ofNullable(clazz.cast(clarificationPrompt()));
        case "abortStatement":
            return Optional.ofNullable(clazz.cast(abortStatement()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "voiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "childDirected":
            return Optional.ofNullable(clazz.cast(childDirected()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, PutBotResponse> {
        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param name
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<Intent> intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Intent... intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Intent>.Builder} avoiding the need to
         * create one manually via {@link List<Intent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Intent>.Builder#build()} is called immediately and its
         * result is passed to {@link #intents(List<Intent>)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link List<Intent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(List<Intent>)
         */
        Builder intents(Consumer<Intent.Builder>... intents);

        /**
         * <p>
         * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
         * <a>PutBot</a>.
         * </p>
         * 
         * @param clarificationPrompt
         *        The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information,
         *        see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clarificationPrompt(Prompt clarificationPrompt);

        /**
         * <p>
         * The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see
         * <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #clarificationPrompt(Prompt)}.
         * 
         * @param clarificationPrompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clarificationPrompt(Prompt)
         */
        default Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return clarificationPrompt(Prompt.builder().applyMutation(clarificationPrompt).build());
        }

        /**
         * <p>
         * The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.
         * </p>
         * 
         * @param abortStatement
         *        The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortStatement(Statement abortStatement);

        /**
         * <p>
         * The message that Amazon Lex uses to abort a conversation. For more information, see <a>PutBot</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #abortStatement(Statement)}.
         * 
         * @param abortStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortStatement(Statement)
         */
        default Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return abortStatement(Statement.builder().applyMutation(abortStatement).build());
        }

        /**
         * <p>
         * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon
         * Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot,
         * it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot, Amazon Lex sets
         * <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
         * <code>failureReason</code> response element.
         * </p>
         * <p>
         * When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
         * <code>NOT BUILT</code>.
         * </p>
         * 
         * @param status
         *        When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
         *        Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex
         *        builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot,
         *        Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the
         *        failure in the <code>failureReason</code> response element. </p>
         *        <p>
         *        When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
         *        <code>NOT BUILT</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon
         * Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot,
         * it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot, Amazon Lex sets
         * <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
         * <code>failureReason</code> response element.
         * </p>
         * <p>
         * When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
         * <code>NOT BUILT</code>.
         * </p>
         * 
         * @param status
         *        When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>,
         *        Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex
         *        builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot,
         *        Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the
         *        failure in the <code>failureReason</code> response element. </p>
         *        <p>
         *        When you set <code>processBehavior</code>to <code>SAVE</code>, Amazon Lex sets the status code to
         *        <code>NOT BUILT</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
         * bot.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build
         *        the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date that the bot was updated. When you create a resource, the creation date and last updated date are
         * the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot was updated. When you create a resource, the creation date and last updated date
         *        are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information,
         * see <a>PutBot</a>.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more
         *        information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see
         * <a>PutBot</a>.
         * </p>
         * 
         * @param voiceId
         *        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more
         *        information, see <a>PutBot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * Checksum of the bot that you created.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
         * </p>
         * 
         * @param version
         *        The version of the bot. For a new bot, the version is always <code>$LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The target locale for the bot.
         * </p>
         * 
         * @param locale
         *        The target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The target locale for the bot.
         * </p>
         * 
         * @param locale
         *        The target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use
         * of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole
         * or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by
         * specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying
         * <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b>
         * related to a website, program, or other application that is directed or targeted, in whole or in part, to
         * children under age 13 and subject to COPPA. By specifying <code>false</code> in the
         * <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website,
         * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
         * subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not
         * accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that
         * is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.
         * </p>
         * <p>
         * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
         * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
         * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that
         * are directed or targeted, in whole or in part, to children under age 13, see the <a
         * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * </p>
         * 
         * @param childDirected
         *        For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether
         *        your use of Amazon Lex is related to a website, program, or other application that is directed or
         *        targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy
         *        Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the
         *        <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code>
         *        field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other
         *        application that is directed or targeted, in whole or in part, to children under age 13 and subject to
         *        COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
         *        use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed
         *        or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a
         *        default value for the <code>childDirected</code> field that does not accurately reflect whether your
         *        use of Amazon Lex is related to a website, program, or other application that is directed or targeted,
         *        in whole or in part, to children under age 13 and subject to COPPA.</p>
         *        <p>
         *        If your use of Amazon Lex relates to a website, program, or other application that is directed in
         *        whole or in part, to children under age 13, you must obtain any required verifiable parental consent
         *        under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or
         *        other applications that are directed or targeted, in whole or in part, to children under age 13, see
         *        the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childDirected(Boolean childDirected);

        /**
         * Sets the value of the CreateVersion property for this object.
         *
         * @param createVersion
         *        The new value for the CreateVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Intent> intents = DefaultSdkAutoConstructList.getInstance();

        private Prompt clarificationPrompt;

        private Statement abortStatement;

        private String status;

        private String failureReason;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private Integer idleSessionTTLInSeconds;

        private String voiceId;

        private String checksum;

        private String version;

        private String locale;

        private Boolean childDirected;

        private Boolean createVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            intents(model.intents);
            clarificationPrompt(model.clarificationPrompt);
            abortStatement(model.abortStatement);
            status(model.status);
            failureReason(model.failureReason);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            voiceId(model.voiceId);
            checksum(model.checksum);
            version(model.version);
            locale(model.locale);
            childDirected(model.childDirected);
            createVersion(model.createVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent.Builder> getIntents() {
            return intents != null ? intents.stream().map(Intent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<Intent.Builder>... intents) {
            intents(Stream.of(intents).map(c -> Intent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        public final Prompt.Builder getClarificationPrompt() {
            return clarificationPrompt != null ? clarificationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        public final Statement.Builder getAbortStatement() {
            return abortStatement != null ? abortStatement.toBuilder() : null;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Boolean getChildDirected() {
            return childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public PutBotResponse build() {
            return new PutBotResponse(this);
        }
    }
}
