/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<StartImportResponse.Builder, StartImportResponse> {
    private final String name;

    private final String resourceType;

    private final String mergeStrategy;

    private final String importId;

    private final String importStatus;

    private final Instant createdDate;

    private StartImportResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The name given to the import job.
     * </p>
     * 
     * @return The name given to the import job.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of resource to import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to import.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource to import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to import.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The action to take when there is a merge conflict.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The action to take when there is a merge conflict.
     * @see MergeStrategy
     */
    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The action to take when there is a merge conflict.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The action to take when there is a merge conflict.
     * @see MergeStrategy
     */
    public String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The identifier for the specific import job.
     * </p>
     * 
     * @return The identifier for the specific import job.
     */
    public String importId() {
        return importId;
    }

    /**
     * <p>
     * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure using
     * the <code>GetImport</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
     *         failure using the <code>GetImport</code> operation.
     * @see ImportStatus
     */
    public ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure using
     * the <code>GetImport</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
     *         failure using the <code>GetImport</code> operation.
     * @see ImportStatus
     */
    public String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * A timestamp for the date and time that the import job was requested.
     * </p>
     * 
     * @return A timestamp for the date and time that the import job was requested.
     */
    public Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportResponse)) {
            return false;
        }
        StartImportResponse other = (StartImportResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(importId(), other.importId())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(createdDate(), other.createdDate());
    }

    @Override
    public String toString() {
        return ToString.builder("StartImportResponse").add("Name", name()).add("ResourceType", resourceTypeAsString())
                .add("MergeStrategy", mergeStrategyAsString()).add("ImportId", importId())
                .add("ImportStatus", importStatusAsString()).add("CreatedDate", createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, StartImportResponse> {
        /**
         * <p>
         * The name given to the import job.
         * </p>
         * 
         * @param name
         *        The name given to the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of resource to import.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to import.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource to import.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to import.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The action to take when there is a merge conflict.
         * </p>
         * 
         * @param mergeStrategy
         *        The action to take when there is a merge conflict.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The action to take when there is a merge conflict.
         * </p>
         * 
         * @param mergeStrategy
         *        The action to take when there is a merge conflict.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The identifier for the specific import job.
         * </p>
         * 
         * @param importId
         *        The identifier for the specific import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure
         * using the <code>GetImport</code> operation.
         * </p>
         * 
         * @param importStatus
         *        The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
         *        failure using the <code>GetImport</code> operation.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure
         * using the <code>GetImport</code> operation.
         * </p>
         * 
         * @param importStatus
         *        The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the
         *        failure using the <code>GetImport</code> operation.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * A timestamp for the date and time that the import job was requested.
         * </p>
         * 
         * @param createdDate
         *        A timestamp for the date and time that the import job was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String resourceType;

        private String mergeStrategy;

        private String importId;

        private String importStatus;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportResponse model) {
            super(model);
            name(model.name);
            resourceType(model.resourceType);
            mergeStrategy(model.mergeStrategy);
            importId(model.importId);
            importStatus(model.importStatus);
            createdDate(model.createdDate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public final String getImportId() {
            return importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus.toString());
            return this;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public StartImportResponse build() {
            return new StartImportResponse(this);
        }
    }
}
