/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartImportRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link StartImportRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class StartImportRequestModelMarshaller {
    private static final MarshallingInfo<SdkBytes> PAYLOAD_BINDING = MarshallingInfo.builder(MarshallingType.SDK_BYTES)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payload").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> MERGESTRATEGY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mergeStrategy").isBinary(false).build();

    private static final StartImportRequestModelMarshaller INSTANCE = new StartImportRequestModelMarshaller();

    private StartImportRequestModelMarshaller() {
    }

    public static StartImportRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(StartImportRequest startImportRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(startImportRequest, "startImportRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(startImportRequest.payload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall(startImportRequest.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(startImportRequest.mergeStrategyAsString(), MERGESTRATEGY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
