/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlot;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBuiltinIntentResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBuiltinIntentResponse> {
    private final String signature;
    private final List<String> supportedLocales;
    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        super(builder);
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    public String signature() {
        return this.signature;
    }

    public List<Locale> supportedLocales() {
        return TypeConverter.convert(this.supportedLocales, Locale::fromValue);
    }

    public List<String> supportedLocalesAsStrings() {
        return this.supportedLocales;
    }

    public List<BuiltinIntentSlot> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedLocalesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse)((Object)obj);
        return Objects.equals(this.signature(), other.signature()) && Objects.equals(this.supportedLocalesAsStrings(), other.supportedLocalesAsStrings()) && Objects.equals(this.slots(), other.slots());
    }

    public String toString() {
        return ToString.builder((String)"GetBuiltinIntentResponse").add("Signature", (Object)this.signature()).add("SupportedLocales", this.supportedLocalesAsStrings()).add("Slots", this.slots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "supportedLocales": {
                return Optional.ofNullable(clazz.cast(this.supportedLocalesAsStrings()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales = DefaultSdkAutoConstructList.getInstance();
        private List<BuiltinIntentSlot> slots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            super(model);
            this.signature(model.signature);
            this.supportedLocalesWithStrings(model.supportedLocales);
            this.slots(model.slots);
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        @Override
        public final Builder supportedLocalesWithStrings(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocalesWithStrings(String ... supportedLocales) {
            this.supportedLocalesWithStrings(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        public final Builder supportedLocales(Collection<Locale> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copyEnumToString(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public final Collection<BuiltinIntentSlot.Builder> getSlots() {
            return this.slots != null ? (Collection)this.slots.stream().map(BuiltinIntentSlot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<BuiltinIntentSlot.Builder> ... slots) {
            this.slots(Stream.of(slots).map(c -> (BuiltinIntentSlot)((BuiltinIntentSlot.Builder)BuiltinIntentSlot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot.BuilderImpl> slots) {
            this.slots = BuiltinIntentSlotListCopier.copyFromBuilder(slots);
        }

        @Override
        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        public Builder signature(String var1);

        public Builder supportedLocalesWithStrings(Collection<String> var1);

        public Builder supportedLocalesWithStrings(String ... var1);

        public Builder supportedLocales(Collection<Locale> var1);

        public Builder supportedLocales(Locale ... var1);

        public Builder slots(Collection<BuiltinIntentSlot> var1);

        public Builder slots(BuiltinIntentSlot ... var1);

        public Builder slots(Consumer<BuiltinIntentSlot.Builder> ... var1);
    }
}

