/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ReferenceType;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInUseException
extends LexModelBuildingException
implements ToCopyableBuilder<Builder, ResourceInUseException> {
    private final String referenceType;
    private final ResourceReference exampleReference;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder);
        this.referenceType = builder.referenceType;
        this.exampleReference = builder.exampleReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public String referenceTypeAsString() {
        return this.referenceType;
    }

    public ResourceReference exampleReference() {
        return this.exampleReference;
    }

    static final class BuilderImpl
    extends LexModelBuildingException.BuilderImpl
    implements Builder {
        private String referenceType;
        private ResourceReference exampleReference;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            super(model);
            this.referenceType(model.referenceType);
            this.exampleReference(model.exampleReference);
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType.toString());
            return this;
        }

        @JsonProperty(value="referenceType")
        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        public final ResourceReference.Builder getExampleReference() {
            return this.exampleReference != null ? this.exampleReference.toBuilder() : null;
        }

        @Override
        public final Builder exampleReference(ResourceReference exampleReference) {
            this.exampleReference = exampleReference;
            return this;
        }

        @JsonProperty(value="exampleReference")
        public final void setExampleReference(ResourceReference.BuilderImpl exampleReference) {
            this.exampleReference = exampleReference != null ? exampleReference.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceInUseException>,
    LexModelBuildingException.Builder {
        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);

        public Builder exampleReference(ResourceReference var1);

        default public Builder exampleReference(Consumer<ResourceReference.Builder> exampleReference) {
            return this.exampleReference((ResourceReference)((ResourceReference.Builder)ResourceReference.builder().applyMutation(exampleReference)).build());
        }

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

