/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.MergeStrategy;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, StartImportRequest> {
    private final SdkBytes payload;
    private final String resourceType;
    private final String mergeStrategy;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.payload = builder.payload;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
    }

    public SdkBytes payload() {
        return this.payload;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest)((Object)obj);
        return Objects.equals(this.payload(), other.payload()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"StartImportRequest").add("Payload", (Object)this.payload()).add("ResourceType", (Object)this.resourceTypeAsString()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private SdkBytes payload;
        private String resourceType;
        private String mergeStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            this.payload(model.payload);
            this.resourceType(model.resourceType);
            this.mergeStrategy(model.mergeStrategy);
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy((SdkBytes)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getMergeStrategy() {
            return this.mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, StartImportRequest> {
        public Builder payload(SdkBytes var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

