/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;

public class GetIntentVersionsIterable
implements SdkIterable<GetIntentVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIntentVersionsIterable(LexModelBuildingClient client, GetIntentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetIntentVersionsResponseFetcher();
    }

    public Iterator<GetIntentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetIntentVersionsIterable resume(GetIntentVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetIntentVersionsIterable(this.client, (GetIntentVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetIntentVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetIntentVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetIntentVersionsResponseFetcher
    implements SyncPageFetcher<GetIntentVersionsResponse> {
        private GetIntentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIntentVersionsResponse nextPage(GetIntentVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentVersionsIterable.this.client.getIntentVersions(GetIntentVersionsIterable.this.firstRequest);
            }
            return GetIntentVersionsIterable.this.client.getIntentVersions((GetIntentVersionsRequest)((Object)GetIntentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

