/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeHookMarshaller {
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messageVersion").isBinary(false).build();
    private static final CodeHookMarshaller INSTANCE = new CodeHookMarshaller();

    private CodeHookMarshaller() {
    }

    public static CodeHookMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeHook codeHook, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeHook, (String)"codeHook");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeHook.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)codeHook.messageVersion(), MESSAGEVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

