/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutIntentRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> SLOTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slots").isBinary(false).build();
    private static final MarshallingInfo<List> SAMPLEUTTERANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleUtterances").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIRMATIONPROMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("confirmationPrompt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REJECTIONSTATEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectionStatement").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FOLLOWUPPROMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("followUpPrompt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONCLUSIONSTATEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conclusionStatement").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DIALOGCODEHOOK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialogCodeHook").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FULFILLMENTACTIVITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fulfillmentActivity").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTINTENTSIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentIntentSignature").isBinary(false).build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checksum").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CREATEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createVersion").isBinary(false).build();
    private static final PutIntentRequestModelMarshaller INSTANCE = new PutIntentRequestModelMarshaller();

    private PutIntentRequestModelMarshaller() {
    }

    public static PutIntentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutIntentRequest putIntentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putIntentRequest), (String)"putIntentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putIntentRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(putIntentRequest.slots(), SLOTS_BINDING);
            protocolMarshaller.marshall(putIntentRequest.sampleUtterances(), SAMPLEUTTERANCES_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.confirmationPrompt(), CONFIRMATIONPROMPT_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.rejectionStatement(), REJECTIONSTATEMENT_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.followUpPrompt(), FOLLOWUPPROMPT_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.conclusionStatement(), CONCLUSIONSTATEMENT_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.dialogCodeHook(), DIALOGCODEHOOK_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.fulfillmentActivity(), FULFILLMENTACTIVITY_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.parentIntentSignature(), PARENTINTENTSIGNATURE_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.checksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)putIntentRequest.createVersion(), CREATEVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

