/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SlotTypeMetadataMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final SlotTypeMetadataMarshaller INSTANCE = new SlotTypeMetadataMarshaller();

    private SlotTypeMetadataMarshaller() {
    }

    public static SlotTypeMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SlotTypeMetadata slotTypeMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)slotTypeMetadata, (String)"slotTypeMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)slotTypeMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)slotTypeMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)slotTypeMetadata.lastUpdatedDate(), LASTUPDATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)slotTypeMetadata.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)slotTypeMetadata.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

