/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.StartImportRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartImportRequestModelMarshaller {
    private static final MarshallingInfo<SdkBytes> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payload").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> MERGESTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mergeStrategy").isBinary(false).build();
    private static final StartImportRequestModelMarshaller INSTANCE = new StartImportRequestModelMarshaller();

    private StartImportRequestModelMarshaller() {
    }

    public static StartImportRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartImportRequest startImportRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startImportRequest), (String)"startImportRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startImportRequest.payload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)startImportRequest.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)startImportRequest.mergeStrategyAsString(), MERGESTRATEGY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

