/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BotChannelAssociationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an association between an Amazon Lex bot and an external messaging platform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BotChannelAssociation implements StructuredPojo,
        ToCopyableBuilder<BotChannelAssociation.Builder, BotChannelAssociation> {
    private final String name;

    private final String description;

    private final String botAlias;

    private final String botName;

    private final Instant createdDate;

    private final String type;

    private final Map<String, String> botConfiguration;

    private BotChannelAssociation(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.botAlias = builder.botAlias;
        this.botName = builder.botName;
        this.createdDate = builder.createdDate;
        this.type = builder.type;
        this.botConfiguration = builder.botConfiguration;
    }

    /**
     * <p>
     * The name of the association between the bot and the channel.
     * </p>
     * 
     * @return The name of the association between the bot and the channel.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A text description of the association you are creating.
     * </p>
     * 
     * @return A text description of the association you are creating.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     * </p>
     * 
     * @return An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     */
    public String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot to which this association is being made.
     * </p>
     * <note>
     * <p>
     * Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.
     * </p>
     * </note>
     * 
     * @return The name of the Amazon Lex bot to which this association is being made. </p> <note>
     *         <p>
     *         Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.
     *         </p>
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the association between the Amazon Lex bot and the channel was created.
     * </p>
     * 
     * @return The date that the association between the Amazon Lex bot and the channel was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Specifies the type of association by indicating the type of channel being established between the Amazon Lex bot
     * and the external messaging platform.
     * </p>
     * 
     * @return Specifies the type of association by indicating the type of channel being established between the Amazon
     *         Lex bot and the external messaging platform.
     * @see ChannelType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Provides information necessary to communicate with the messaging platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Provides information necessary to communicate with the messaging platform.
     */
    public Map<String, String> botConfiguration() {
        return botConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((botAlias() == null) ? 0 : botAlias().hashCode());
        hashCode = 31 * hashCode + ((botName() == null) ? 0 : botName().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((botConfiguration() == null) ? 0 : botConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotChannelAssociation)) {
            return false;
        }
        BotChannelAssociation other = (BotChannelAssociation) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.botAlias() == null ^ this.botAlias() == null) {
            return false;
        }
        if (other.botAlias() != null && !other.botAlias().equals(this.botAlias())) {
            return false;
        }
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.botConfiguration() == null ^ this.botConfiguration() == null) {
            return false;
        }
        if (other.botConfiguration() != null && !other.botConfiguration().equals(this.botConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (botAlias() != null) {
            sb.append("BotAlias: ").append(botAlias()).append(",");
        }
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (botConfiguration() != null) {
            sb.append("BotConfiguration: ").append(botConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BotChannelAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BotChannelAssociation> {
        /**
         * <p>
         * The name of the association between the bot and the channel.
         * </p>
         * 
         * @param name
         *        The name of the association between the bot and the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A text description of the association you are creating.
         * </p>
         * 
         * @param description
         *        A text description of the association you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
         * </p>
         * 
         * @param botAlias
         *        An alias pointing to the specific version of the Amazon Lex bot to which this association is being
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The name of the Amazon Lex bot to which this association is being made.
         * </p>
         * <note>
         * <p>
         * Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.
         * </p>
         * </note>
         * 
         * @param botName
         *        The name of the Amazon Lex bot to which this association is being made. </p> <note>
         *        <p>
         *        Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the association between the Amazon Lex bot and the channel was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the association between the Amazon Lex bot and the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Specifies the type of association by indicating the type of channel being established between the Amazon Lex
         * bot and the external messaging platform.
         * </p>
         * 
         * @param type
         *        Specifies the type of association by indicating the type of channel being established between the
         *        Amazon Lex bot and the external messaging platform.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of association by indicating the type of channel being established between the Amazon Lex
         * bot and the external messaging platform.
         * </p>
         * 
         * @param type
         *        Specifies the type of association by indicating the type of channel being established between the
         *        Amazon Lex bot and the external messaging platform.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Provides information necessary to communicate with the messaging platform.
         * </p>
         * 
         * @param botConfiguration
         *        Provides information necessary to communicate with the messaging platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botConfiguration(Map<String, String> botConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botAlias;

        private String botName;

        private Instant createdDate;

        private String type;

        private Map<String, String> botConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BotChannelAssociation model) {
            setName(model.name);
            setDescription(model.description);
            setBotAlias(model.botAlias);
            setBotName(model.botName);
            setCreatedDate(model.createdDate);
            setType(model.type);
            setBotConfiguration(model.botConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ChannelType type) {
            this.type(type.toString());
        }

        public final Map<String, String> getBotConfiguration() {
            return botConfiguration;
        }

        @Override
        public final Builder botConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
            return this;
        }

        public final void setBotConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
        }

        @Override
        public BotChannelAssociation build() {
            return new BotChannelAssociation(this);
        }
    }
}
