/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CodeHookMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CodeHook implements StructuredPojo, ToCopyableBuilder<CodeHook.Builder, CodeHook> {
    private final String uri;

    private final String messageVersion;

    private CodeHook(BuilderImpl builder) {
        this.uri = builder.uri;
        this.messageVersion = builder.messageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public String uri() {
        return uri;
    }

    /**
     * <p>
     * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
     * information, see <a>using-lambda</a>.
     * </p>
     * 
     * @return The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For
     *         more information, see <a>using-lambda</a>.
     */
    public String messageVersion() {
        return messageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((uri() == null) ? 0 : uri().hashCode());
        hashCode = 31 * hashCode + ((messageVersion() == null) ? 0 : messageVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHook)) {
            return false;
        }
        CodeHook other = (CodeHook) obj;
        if (other.uri() == null ^ this.uri() == null) {
            return false;
        }
        if (other.uri() != null && !other.uri().equals(this.uri())) {
            return false;
        }
        if (other.messageVersion() == null ^ this.messageVersion() == null) {
            return false;
        }
        if (other.messageVersion() != null && !other.messageVersion().equals(this.messageVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (uri() != null) {
            sb.append("Uri: ").append(uri()).append(",");
        }
        if (messageVersion() != null) {
            sb.append("MessageVersion: ").append(messageVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeHookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CodeHook> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param uri
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
         * information, see <a>using-lambda</a>.
         * </p>
         * 
         * @param messageVersion
         *        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         *        For more information, see <a>using-lambda</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageVersion(String messageVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String uri;

        private String messageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHook model) {
            setUri(model.uri);
            setMessageVersion(model.messageVersion);
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMessageVersion() {
            return messageVersion;
        }

        @Override
        public final Builder messageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        public final void setMessageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
        }

        @Override
        public CodeHook build() {
            return new CodeHook(this);
        }
    }
}
