/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateBotVersionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateBotVersionResponse.Builder, CreateBotVersionResponse> {
    private final String name;

    private final String description;

    private final List<Intent> intents;

    private final Prompt clarificationPrompt;

    private final Statement abortStatement;

    private final String status;

    private final String failureReason;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final Integer idleSessionTTLInSeconds;

    private final String voiceId;

    private final String checksum;

    private final String version;

    private final String locale;

    private final Boolean childDirected;

    private CreateBotVersionResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.version = builder.version;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An array of <code>Intent</code> objects. For more information, see .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Intent</code> objects. For more information, see .
     */
    public List<Intent> intents() {
        return intents;
    }

    /**
     * <p>
     * The message that Amazon Lex uses when it doesn't understand the user's request. For more information, see .
     * </p>
     * 
     * @return The message that Amazon Lex uses when it doesn't understand the user's request. For more information, see
     *         .
     */
    public Prompt clarificationPrompt() {
        return clarificationPrompt;
    }

    /**
     * <p>
     * The message that Amazon Lex uses to abort a conversation. For more information, see .
     * </p>
     * 
     * @return The message that Amazon Lex uses to abort a conversation. For more information, see .
     */
    public Statement abortStatement() {
        return abortStatement;
    }

    /**
     * <p>
     * When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element to
     * <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>. If
     * Amazon Lex can't build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason
     * for the failure in the <code>failureReason</code> response element.
     * </p>
     * 
     * @return When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response
     *         element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to
     *         <code>READY</code>. If Amazon Lex can't build the bot, it sets <code>status</code> to <code>FAILED</code>
     *         . Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element.
     * @see Status
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
     *         bot.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date when the <code>$LATEST</code> version of this bot was updated.
     * </p>
     * 
     * @return The date when the <code>$LATEST</code> version of this bot was updated.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date when the bot version was created.
     * </p>
     * 
     * @return The date when the bot version was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information,
     * see .
     * </p>
     * 
     * @return The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more
     *         information, see .
     */
    public Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.
     * </p>
     * 
     * @return The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.
     */
    public String voiceId() {
        return voiceId;
    }

    /**
     * <p>
     * Checksum identifying the version of the bot that was created.
     * </p>
     * 
     * @return Checksum identifying the version of the bot that was created.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The version of the bot.
     * </p>
     * 
     * @return The version of the bot.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Specifies the target locale for the bot.
     * </p>
     * 
     * @return Specifies the target locale for the bot.
     * @see Locale
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of
     * Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in
     * part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying
     * <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code>
     * in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website,
     * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
     * subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
     * use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted,
     * in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the
     * <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a
     * website, program, or other application that is directed or targeted, in whole or in part, to children under age
     * 13 and subject to COPPA.
     * </p>
     * <p>
     * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
     * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
     * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are
     * directed or targeted, in whole or in part, to children under age 13, see the <a
     * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     * </p>
     * 
     * @return For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your
     *         use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in
     *         whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act
     *         (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By
     *         specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon
     *         Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole
     *         or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the
     *         <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a
     *         website, program, or other application that is directed or targeted, in whole or in part, to children
     *         under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code>
     *         field that does not accurately reflect whether your use of Amazon Lex is related to a website, program,
     *         or other application that is directed or targeted, in whole or in part, to children under age 13 and
     *         subject to COPPA.</p>
     *         <p>
     *         If your use of Amazon Lex relates to a website, program, or other application that is directed in whole
     *         or in part, to children under age 13, you must obtain any required verifiable parental consent under
     *         COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other
     *         applications that are directed or targeted, in whole or in part, to children under age 13, see the <a
     *         href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
     */
    public Boolean childDirected() {
        return childDirected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((intents() == null) ? 0 : intents().hashCode());
        hashCode = 31 * hashCode + ((clarificationPrompt() == null) ? 0 : clarificationPrompt().hashCode());
        hashCode = 31 * hashCode + ((abortStatement() == null) ? 0 : abortStatement().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((failureReason() == null) ? 0 : failureReason().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedDate() == null) ? 0 : lastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((idleSessionTTLInSeconds() == null) ? 0 : idleSessionTTLInSeconds().hashCode());
        hashCode = 31 * hashCode + ((voiceId() == null) ? 0 : voiceId().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((locale() == null) ? 0 : locale().hashCode());
        hashCode = 31 * hashCode + ((childDirected() == null) ? 0 : childDirected().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotVersionResponse)) {
            return false;
        }
        CreateBotVersionResponse other = (CreateBotVersionResponse) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.intents() == null ^ this.intents() == null) {
            return false;
        }
        if (other.intents() != null && !other.intents().equals(this.intents())) {
            return false;
        }
        if (other.clarificationPrompt() == null ^ this.clarificationPrompt() == null) {
            return false;
        }
        if (other.clarificationPrompt() != null && !other.clarificationPrompt().equals(this.clarificationPrompt())) {
            return false;
        }
        if (other.abortStatement() == null ^ this.abortStatement() == null) {
            return false;
        }
        if (other.abortStatement() != null && !other.abortStatement().equals(this.abortStatement())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.failureReason() == null ^ this.failureReason() == null) {
            return false;
        }
        if (other.failureReason() != null && !other.failureReason().equals(this.failureReason())) {
            return false;
        }
        if (other.lastUpdatedDate() == null ^ this.lastUpdatedDate() == null) {
            return false;
        }
        if (other.lastUpdatedDate() != null && !other.lastUpdatedDate().equals(this.lastUpdatedDate())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.idleSessionTTLInSeconds() == null ^ this.idleSessionTTLInSeconds() == null) {
            return false;
        }
        if (other.idleSessionTTLInSeconds() != null && !other.idleSessionTTLInSeconds().equals(this.idleSessionTTLInSeconds())) {
            return false;
        }
        if (other.voiceId() == null ^ this.voiceId() == null) {
            return false;
        }
        if (other.voiceId() != null && !other.voiceId().equals(this.voiceId())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.childDirected() == null ^ this.childDirected() == null) {
            return false;
        }
        if (other.childDirected() != null && !other.childDirected().equals(this.childDirected())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (intents() != null) {
            sb.append("Intents: ").append(intents()).append(",");
        }
        if (clarificationPrompt() != null) {
            sb.append("ClarificationPrompt: ").append(clarificationPrompt()).append(",");
        }
        if (abortStatement() != null) {
            sb.append("AbortStatement: ").append(abortStatement()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (failureReason() != null) {
            sb.append("FailureReason: ").append(failureReason()).append(",");
        }
        if (lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(lastUpdatedDate()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (idleSessionTTLInSeconds() != null) {
            sb.append("IdleSessionTTLInSeconds: ").append(idleSessionTTLInSeconds()).append(",");
        }
        if (voiceId() != null) {
            sb.append("VoiceId: ").append(voiceId()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (locale() != null) {
            sb.append("Locale: ").append(locale()).append(",");
        }
        if (childDirected() != null) {
            sb.append("ChildDirected: ").append(childDirected()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateBotVersionResponse> {
        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param name
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see .
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<Intent> intents);

        /**
         * <p>
         * An array of <code>Intent</code> objects. For more information, see .
         * </p>
         * 
         * @param intents
         *        An array of <code>Intent</code> objects. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Intent... intents);

        /**
         * <p>
         * The message that Amazon Lex uses when it doesn't understand the user's request. For more information, see .
         * </p>
         * 
         * @param clarificationPrompt
         *        The message that Amazon Lex uses when it doesn't understand the user's request. For more information,
         *        see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clarificationPrompt(Prompt clarificationPrompt);

        /**
         * <p>
         * The message that Amazon Lex uses to abort a conversation. For more information, see .
         * </p>
         * 
         * @param abortStatement
         *        The message that Amazon Lex uses to abort a conversation. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortStatement(Statement abortStatement);

        /**
         * <p>
         * When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element
         * to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
         * If Amazon Lex can't build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the
         * reason for the failure in the <code>failureReason</code> response element.
         * </p>
         * 
         * @param status
         *        When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response
         *        element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to
         *        <code>READY</code>. If Amazon Lex can't build the bot, it sets <code>status</code> to
         *        <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code>
         *        response element.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element
         * to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
         * If Amazon Lex can't build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the
         * reason for the failure in the <code>failureReason</code> response element.
         * </p>
         * 
         * @param status
         *        When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response
         *        element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to
         *        <code>READY</code>. If Amazon Lex can't build the bot, it sets <code>status</code> to
         *        <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code>
         *        response element.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the
         * bot.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build
         *        the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date when the <code>$LATEST</code> version of this bot was updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date when the <code>$LATEST</code> version of this bot was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date when the bot version was created.
         * </p>
         * 
         * @param createdDate
         *        The date when the bot version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more
         * information, see .
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more
         *        information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.
         * </p>
         * 
         * @param voiceId
         *        The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * Checksum identifying the version of the bot that was created.
         * </p>
         * 
         * @param checksum
         *        Checksum identifying the version of the bot that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The version of the bot.
         * </p>
         * 
         * @param version
         *        The version of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Specifies the target locale for the bot.
         * </p>
         * 
         * @param locale
         *        Specifies the target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * Specifies the target locale for the bot.
         * </p>
         * 
         * @param locale
         *        Specifies the target locale for the bot.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use
         * of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole
         * or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by
         * specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying
         * <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b>
         * related to a website, program, or other application that is directed or targeted, in whole or in part, to
         * children under age 13 and subject to COPPA. By specifying <code>false</code> in the
         * <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website,
         * program, or other application that is directed or targeted, in whole or in part, to children under age 13 and
         * subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not
         * accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that
         * is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.
         * </p>
         * <p>
         * If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in
         * part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For
         * information regarding the use of Amazon Lex in connection with websites, programs, or other applications that
         * are directed or targeted, in whole or in part, to children under age 13, see the <a
         * href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * </p>
         * 
         * @param childDirected
         *        For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether
         *        your use of Amazon Lex is related to a website, program, or other application that is directed or
         *        targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy
         *        Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the
         *        <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code>
         *        field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other
         *        application that is directed or targeted, in whole or in part, to children under age 13 and subject to
         *        COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your
         *        use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed
         *        or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a
         *        default value for the <code>childDirected</code> field that does not accurately reflect whether your
         *        use of Amazon Lex is related to a website, program, or other application that is directed or targeted,
         *        in whole or in part, to children under age 13 and subject to COPPA.</p>
         *        <p>
         *        If your use of Amazon Lex relates to a website, program, or other application that is directed in
         *        whole or in part, to children under age 13, you must obtain any required verifiable parental consent
         *        under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or
         *        other applications that are directed or targeted, in whole or in part, to children under age 13, see
         *        the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childDirected(Boolean childDirected);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Intent> intents;

        private Prompt clarificationPrompt;

        private Statement abortStatement;

        private String status;

        private String failureReason;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private Integer idleSessionTTLInSeconds;

        private String voiceId;

        private String checksum;

        private String version;

        private String locale;

        private Boolean childDirected;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotVersionResponse model) {
            setName(model.name);
            setDescription(model.description);
            setIntents(model.intents);
            setClarificationPrompt(model.clarificationPrompt);
            setAbortStatement(model.abortStatement);
            setStatus(model.status);
            setFailureReason(model.failureReason);
            setLastUpdatedDate(model.lastUpdatedDate);
            setCreatedDate(model.createdDate);
            setIdleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            setVoiceId(model.voiceId);
            setChecksum(model.checksum);
            setVersion(model.version);
            setLocale(model.locale);
            setChildDirected(model.childDirected);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent> getIntents() {
            return intents;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
        }

        @SafeVarargs
        public final void setIntents(Intent... intents) {
            intents(Arrays.asList(intents));
        }

        public final Prompt getClarificationPrompt() {
            return clarificationPrompt;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
        }

        public final Statement getAbortStatement() {
            return abortStatement;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(Status status) {
            this.status(status.toString());
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final void setLocale(Locale locale) {
            this.locale(locale.toString());
        }

        public final Boolean getChildDirected() {
            return childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        @Override
        public CreateBotVersionResponse build() {
            return new CreateBotVersionResponse(this);
        }
    }
}
