/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBotsResponse.Builder, GetBotsResponse> {
    private final List<BotMetadata> bots;

    private final String nextToken;

    private GetBotsResponse(BuilderImpl builder) {
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>botMetadata</code> objects, with one entry for each bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>botMetadata</code> objects, with one entry for each bot.
     */
    public List<BotMetadata> bots() {
        return bots;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of bots.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of bots.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bots() == null) ? 0 : bots().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotsResponse)) {
            return false;
        }
        GetBotsResponse other = (GetBotsResponse) obj;
        if (other.bots() == null ^ this.bots() == null) {
            return false;
        }
        if (other.bots() != null && !other.bots().equals(this.bots())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bots() != null) {
            sb.append("Bots: ").append(bots()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBotsResponse> {
        /**
         * <p>
         * An array of <code>botMetadata</code> objects, with one entry for each bot.
         * </p>
         * 
         * @param bots
         *        An array of <code>botMetadata</code> objects, with one entry for each bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(Collection<BotMetadata> bots);

        /**
         * <p>
         * An array of <code>botMetadata</code> objects, with one entry for each bot.
         * </p>
         * 
         * @param bots
         *        An array of <code>botMetadata</code> objects, with one entry for each bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(BotMetadata... bots);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of bots.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<BotMetadata> bots;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotsResponse model) {
            setBots(model.bots);
            setNextToken(model.nextToken);
        }

        public final Collection<BotMetadata> getBots() {
            return bots;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata... bots) {
            bots(Arrays.asList(bots));
            return this;
        }

        public final void setBots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
        }

        @SafeVarargs
        public final void setBots(BotMetadata... bots) {
            bots(Arrays.asList(bots));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotsResponse build() {
            return new GetBotsResponse(this);
        }
    }
}
