/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIntentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIntentResponse.Builder, GetIntentResponse> {
    private final String name;

    private final String description;

    private final List<Slot> slots;

    private final List<String> sampleUtterances;

    private final Prompt confirmationPrompt;

    private final Statement rejectionStatement;

    private final FollowUpPrompt followUpPrompt;

    private final Statement conclusionStatement;

    private final CodeHook dialogCodeHook;

    private final FulfillmentActivity fulfillmentActivity;

    private final String parentIntentSignature;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String version;

    private final String checksum;

    private GetIntentResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the intent.
     * </p>
     * 
     * @return A description of the intent.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An array of intent slots configured for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of intent slots configured for the intent.
     */
    public List<Slot> slots() {
        return slots;
    }

    /**
     * <p>
     * An array of sample utterances configured for the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of sample utterances configured for the intent.
     */
    public List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user's request. For
     * more information, see .
     * </p>
     * 
     * @return If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user's request.
     *         For more information, see .
     */
    public Prompt confirmationPrompt() {
        return confirmationPrompt;
    }

    /**
     * <p>
     * If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
     * this statement to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds
     *         with this statement to acknowledge that the intent was canceled.
     */
    public Statement rejectionStatement() {
        return rejectionStatement;
    }

    /**
     * <p>
     * If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent is
     * fulfilled. For more information, see .
     * </p>
     * 
     * @return If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent
     *         is fulfilled. For more information, see .
     */
    public FollowUpPrompt followUpPrompt() {
        return followUpPrompt;
    }

    /**
     * <p>
     * After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent, Amazon
     * Lex conveys this statement to the user.
     * </p>
     * 
     * @return After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent,
     *         Amazon Lex conveys this statement to the user.
     */
    public Statement conclusionStatement() {
        return conclusionStatement;
    }

    /**
     * <p>
     * If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more information,
     * see .
     * </p>
     * 
     * @return If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more
     *         information, see .
     */
    public CodeHook dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * Describes how the intent is fulfilled. For more information, see .
     * </p>
     * 
     * @return Describes how the intent is fulfilled. For more information, see .
     */
    public FulfillmentActivity fulfillmentActivity() {
        return fulfillmentActivity;
    }

    /**
     * <p>
     * A unique identifier for a built-in intent.
     * </p>
     * 
     * @return A unique identifier for a built-in intent.
     */
    public String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * <p>
     * The date that the intent was updated. When you create a resource, the creation date and the last updated date are
     * the same.
     * </p>
     * 
     * @return The date that the intent was updated. When you create a resource, the creation date and the last updated
     *         date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the intent was created.
     * </p>
     * 
     * @return The date that the intent was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version of the intent.
     * </p>
     * 
     * @return The version of the intent.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the intent.
     * </p>
     * 
     * @return Checksum of the intent.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((slots() == null) ? 0 : slots().hashCode());
        hashCode = 31 * hashCode + ((sampleUtterances() == null) ? 0 : sampleUtterances().hashCode());
        hashCode = 31 * hashCode + ((confirmationPrompt() == null) ? 0 : confirmationPrompt().hashCode());
        hashCode = 31 * hashCode + ((rejectionStatement() == null) ? 0 : rejectionStatement().hashCode());
        hashCode = 31 * hashCode + ((followUpPrompt() == null) ? 0 : followUpPrompt().hashCode());
        hashCode = 31 * hashCode + ((conclusionStatement() == null) ? 0 : conclusionStatement().hashCode());
        hashCode = 31 * hashCode + ((dialogCodeHook() == null) ? 0 : dialogCodeHook().hashCode());
        hashCode = 31 * hashCode + ((fulfillmentActivity() == null) ? 0 : fulfillmentActivity().hashCode());
        hashCode = 31 * hashCode + ((parentIntentSignature() == null) ? 0 : parentIntentSignature().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedDate() == null) ? 0 : lastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentResponse)) {
            return false;
        }
        GetIntentResponse other = (GetIntentResponse) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        if (other.sampleUtterances() == null ^ this.sampleUtterances() == null) {
            return false;
        }
        if (other.sampleUtterances() != null && !other.sampleUtterances().equals(this.sampleUtterances())) {
            return false;
        }
        if (other.confirmationPrompt() == null ^ this.confirmationPrompt() == null) {
            return false;
        }
        if (other.confirmationPrompt() != null && !other.confirmationPrompt().equals(this.confirmationPrompt())) {
            return false;
        }
        if (other.rejectionStatement() == null ^ this.rejectionStatement() == null) {
            return false;
        }
        if (other.rejectionStatement() != null && !other.rejectionStatement().equals(this.rejectionStatement())) {
            return false;
        }
        if (other.followUpPrompt() == null ^ this.followUpPrompt() == null) {
            return false;
        }
        if (other.followUpPrompt() != null && !other.followUpPrompt().equals(this.followUpPrompt())) {
            return false;
        }
        if (other.conclusionStatement() == null ^ this.conclusionStatement() == null) {
            return false;
        }
        if (other.conclusionStatement() != null && !other.conclusionStatement().equals(this.conclusionStatement())) {
            return false;
        }
        if (other.dialogCodeHook() == null ^ this.dialogCodeHook() == null) {
            return false;
        }
        if (other.dialogCodeHook() != null && !other.dialogCodeHook().equals(this.dialogCodeHook())) {
            return false;
        }
        if (other.fulfillmentActivity() == null ^ this.fulfillmentActivity() == null) {
            return false;
        }
        if (other.fulfillmentActivity() != null && !other.fulfillmentActivity().equals(this.fulfillmentActivity())) {
            return false;
        }
        if (other.parentIntentSignature() == null ^ this.parentIntentSignature() == null) {
            return false;
        }
        if (other.parentIntentSignature() != null && !other.parentIntentSignature().equals(this.parentIntentSignature())) {
            return false;
        }
        if (other.lastUpdatedDate() == null ^ this.lastUpdatedDate() == null) {
            return false;
        }
        if (other.lastUpdatedDate() != null && !other.lastUpdatedDate().equals(this.lastUpdatedDate())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (slots() != null) {
            sb.append("Slots: ").append(slots()).append(",");
        }
        if (sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(sampleUtterances()).append(",");
        }
        if (confirmationPrompt() != null) {
            sb.append("ConfirmationPrompt: ").append(confirmationPrompt()).append(",");
        }
        if (rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(rejectionStatement()).append(",");
        }
        if (followUpPrompt() != null) {
            sb.append("FollowUpPrompt: ").append(followUpPrompt()).append(",");
        }
        if (conclusionStatement() != null) {
            sb.append("ConclusionStatement: ").append(conclusionStatement()).append(",");
        }
        if (dialogCodeHook() != null) {
            sb.append("DialogCodeHook: ").append(dialogCodeHook()).append(",");
        }
        if (fulfillmentActivity() != null) {
            sb.append("FulfillmentActivity: ").append(fulfillmentActivity()).append(",");
        }
        if (parentIntentSignature() != null) {
            sb.append("ParentIntentSignature: ").append(parentIntentSignature()).append(",");
        }
        if (lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(lastUpdatedDate()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIntentResponse> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param name
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the intent.
         * </p>
         * 
         * @param description
         *        A description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of intent slots configured for the intent.
         * </p>
         * 
         * @param slots
         *        An array of intent slots configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * An array of intent slots configured for the intent.
         * </p>
         * 
         * @param slots
         *        An array of intent slots configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * An array of sample utterances configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * An array of sample utterances configured for the intent.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of sample utterances configured for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user's request. For
         * more information, see .
         * </p>
         * 
         * @param confirmationPrompt
         *        If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user's
         *        request. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationPrompt(Prompt confirmationPrompt);

        /**
         * <p>
         * If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param rejectionStatement
         *        If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
         *        responds with this statement to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent is
         * fulfilled. For more information, see .
         * </p>
         * 
         * @param followUpPrompt
         *        If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the
         *        intent is fulfilled. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followUpPrompt(FollowUpPrompt followUpPrompt);

        /**
         * <p>
         * After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent,
         * Amazon Lex conveys this statement to the user.
         * </p>
         * 
         * @param conclusionStatement
         *        After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the
         *        intent, Amazon Lex conveys this statement to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conclusionStatement(Statement conclusionStatement);

        /**
         * <p>
         * If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more
         * information, see .
         * </p>
         * 
         * @param dialogCodeHook
         *        If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more
         *        information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(CodeHook dialogCodeHook);

        /**
         * <p>
         * Describes how the intent is fulfilled. For more information, see .
         * </p>
         * 
         * @param fulfillmentActivity
         *        Describes how the intent is fulfilled. For more information, see .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity);

        /**
         * <p>
         * A unique identifier for a built-in intent.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for a built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The date that the intent was updated. When you create a resource, the creation date and the last updated date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the intent was updated. When you create a resource, the creation date and the last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the intent was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The version of the intent.
         * </p>
         * 
         * @param version
         *        The version of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the intent.
         * </p>
         * 
         * @param checksum
         *        Checksum of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Slot> slots;

        private List<String> sampleUtterances;

        private Prompt confirmationPrompt;

        private Statement rejectionStatement;

        private FollowUpPrompt followUpPrompt;

        private Statement conclusionStatement;

        private CodeHook dialogCodeHook;

        private FulfillmentActivity fulfillmentActivity;

        private String parentIntentSignature;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String version;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentResponse model) {
            setName(model.name);
            setDescription(model.description);
            setSlots(model.slots);
            setSampleUtterances(model.sampleUtterances);
            setConfirmationPrompt(model.confirmationPrompt);
            setRejectionStatement(model.rejectionStatement);
            setFollowUpPrompt(model.followUpPrompt);
            setConclusionStatement(model.conclusionStatement);
            setDialogCodeHook(model.dialogCodeHook);
            setFulfillmentActivity(model.fulfillmentActivity);
            setParentIntentSignature(model.parentIntentSignature);
            setLastUpdatedDate(model.lastUpdatedDate);
            setCreatedDate(model.createdDate);
            setVersion(model.version);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot> getSlots() {
            return slots;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
        }

        @SafeVarargs
        public final void setSlots(Slot... slots) {
            slots(Arrays.asList(slots));
        }

        public final Collection<String> getSampleUtterances() {
            return sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        @SafeVarargs
        public final void setSampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
        }

        public final Prompt getConfirmationPrompt() {
            return confirmationPrompt;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
        }

        public final Statement getRejectionStatement() {
            return rejectionStatement;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
        }

        public final FollowUpPrompt getFollowUpPrompt() {
            return followUpPrompt;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
        }

        public final Statement getConclusionStatement() {
            return conclusionStatement;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
        }

        public final CodeHook getDialogCodeHook() {
            return dialogCodeHook;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
        }

        public final FulfillmentActivity getFulfillmentActivity() {
            return fulfillmentActivity;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public GetIntentResponse build() {
            return new GetIntentResponse(this);
        }
    }
}
