/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSlotTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSlotTypesResponse.Builder, GetSlotTypesResponse> {
    private final List<SlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetSlotTypesResponse(BuilderImpl builder) {
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
     * version, and a description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects, one for each slot type, that provides information such as the name of the slot type,
     *         the version, and a description.
     */
    public List<SlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of slot types.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of slot types.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((slotTypes() == null) ? 0 : slotTypes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypesResponse)) {
            return false;
        }
        GetSlotTypesResponse other = (GetSlotTypesResponse) obj;
        if (other.slotTypes() == null ^ this.slotTypes() == null) {
            return false;
        }
        if (other.slotTypes() != null && !other.slotTypes().equals(this.slotTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (slotTypes() != null) {
            sb.append("SlotTypes: ").append(slotTypes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSlotTypesResponse> {
        /**
         * <p>
         * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
         * version, and a description.
         * </p>
         * 
         * @param slotTypes
         *        An array of objects, one for each slot type, that provides information such as the name of the slot
         *        type, the version, and a description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<SlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of objects, one for each slot type, that provides information such as the name of the slot type, the
         * version, and a description.
         * </p>
         * 
         * @param slotTypes
         *        An array of objects, one for each slot type, that provides information such as the name of the slot
         *        type, the version, and a description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(SlotTypeMetadata... slotTypes);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of slot types.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<SlotTypeMetadata> slotTypes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypesResponse model) {
            setSlotTypes(model.slotTypes);
            setNextToken(model.nextToken);
        }

        public final Collection<SlotTypeMetadata> getSlotTypes() {
            return slotTypes;
        }

        @Override
        public final Builder slotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(SlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        public final void setSlotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
        }

        @SafeVarargs
        public final void setSlotTypes(SlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSlotTypesResponse build() {
            return new GetSlotTypesResponse(this);
        }
    }
}
