/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PromptMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Obtains information from the user. To define a prompt, provide one or more messages and specify the number of
 * attempts to get information from the user. If you provide more than one message, Amazon Lex chooses one of the
 * messages to use to prompt the user. For more information, see <a>how-it-works</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Prompt implements StructuredPojo, ToCopyableBuilder<Prompt.Builder, Prompt> {
    private final List<Message> messages;

    private final Integer maxAttempts;

    private final String responseCard;

    private Prompt(BuilderImpl builder) {
        this.messages = builder.messages;
        this.maxAttempts = builder.maxAttempts;
        this.responseCard = builder.responseCard;
    }

    /**
     * <p>
     * An array of objects, each of which provides a message string and its type. You can specify the message string in
     * plain text or in Speech Synthesis Markup Language (SSML).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects, each of which provides a message string and its type. You can specify the message
     *         string in plain text or in Speech Synthesis Markup Language (SSML).
     */
    public List<Message> messages() {
        return messages;
    }

    /**
     * <p>
     * The number of times to prompt the user for information.
     * </p>
     * 
     * @return The number of times to prompt the user for information.
     */
    public Integer maxAttempts() {
        return maxAttempts;
    }

    /**
     * <p>
     * A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
     * substitutes session attributes and slot values for placeholders in the response card. For more information, see
     * <a>ex-resp-card</a>.
     * </p>
     * 
     * @return A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
     *         substitutes session attributes and slot values for placeholders in the response card. For more
     *         information, see <a>ex-resp-card</a>.
     */
    public String responseCard() {
        return responseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((messages() == null) ? 0 : messages().hashCode());
        hashCode = 31 * hashCode + ((maxAttempts() == null) ? 0 : maxAttempts().hashCode());
        hashCode = 31 * hashCode + ((responseCard() == null) ? 0 : responseCard().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt) obj;
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        if (other.maxAttempts() == null ^ this.maxAttempts() == null) {
            return false;
        }
        if (other.maxAttempts() != null && !other.maxAttempts().equals(this.maxAttempts())) {
            return false;
        }
        if (other.responseCard() == null ^ this.responseCard() == null) {
            return false;
        }
        if (other.responseCard() != null && !other.responseCard().equals(this.responseCard())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (messages() != null) {
            sb.append("Messages: ").append(messages()).append(",");
        }
        if (maxAttempts() != null) {
            sb.append("MaxAttempts: ").append(maxAttempts()).append(",");
        }
        if (responseCard() != null) {
            sb.append("ResponseCard: ").append(responseCard()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Prompt> {
        /**
         * <p>
         * An array of objects, each of which provides a message string and its type. You can specify the message string
         * in plain text or in Speech Synthesis Markup Language (SSML).
         * </p>
         * 
         * @param messages
         *        An array of objects, each of which provides a message string and its type. You can specify the message
         *        string in plain text or in Speech Synthesis Markup Language (SSML).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * An array of objects, each of which provides a message string and its type. You can specify the message string
         * in plain text or in Speech Synthesis Markup Language (SSML).
         * </p>
         * 
         * @param messages
         *        An array of objects, each of which provides a message string and its type. You can specify the message
         *        string in plain text or in Speech Synthesis Markup Language (SSML).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * The number of times to prompt the user for information.
         * </p>
         * 
         * @param maxAttempts
         *        The number of times to prompt the user for information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAttempts(Integer maxAttempts);

        /**
         * <p>
         * A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
         * substitutes session attributes and slot values for placeholders in the response card. For more information,
         * see <a>ex-resp-card</a>.
         * </p>
         * 
         * @param responseCard
         *        A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It
         *        substitutes session attributes and slot values for placeholders in the response card. For more
         *        information, see <a>ex-resp-card</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCard(String responseCard);
    }

    private static final class BuilderImpl implements Builder {
        private List<Message> messages;

        private Integer maxAttempts;

        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Prompt model) {
            setMessages(model.messages);
            setMaxAttempts(model.maxAttempts);
            setResponseCard(model.responseCard);
        }

        public final Collection<Message> getMessages() {
            return messages;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(Message... messages) {
            messages(Arrays.asList(messages));
        }

        public final Integer getMaxAttempts() {
            return maxAttempts;
        }

        @Override
        public final Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public final void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public final String getResponseCard() {
            return responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        @Override
        public Prompt build() {
            return new Prompt(this);
        }
    }
}
