/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlot;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinIntentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBuiltinIntentResponse> {
    private final String signature;
    private final List<String> supportedLocales;
    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    public String signature() {
        return this.signature;
    }

    public List<String> supportedLocales() {
        return this.supportedLocales;
    }

    public List<BuiltinIntentSlot> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.signature() == null ? 0 : this.signature().hashCode());
        hashCode = 31 * hashCode + (this.supportedLocales() == null ? 0 : this.supportedLocales().hashCode());
        hashCode = 31 * hashCode + (this.slots() == null ? 0 : this.slots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse)((Object)obj);
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.supportedLocales() == null ^ this.supportedLocales() == null) {
            return false;
        }
        if (other.supportedLocales() != null && !other.supportedLocales().equals(this.supportedLocales())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        return other.slots() == null || other.slots().equals(this.slots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (this.supportedLocales() != null) {
            sb.append("SupportedLocales: ").append(this.supportedLocales()).append(",");
        }
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales;
        private List<BuiltinIntentSlot> slots;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            this.setSignature(model.signature);
            this.setSupportedLocales(model.supportedLocales);
            this.setSlots(model.slots);
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @SafeVarargs
        public final void setSupportedLocales(String ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
        }

        @SafeVarargs
        public final void setSupportedLocales(Locale ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final Collection<BuiltinIntentSlot> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
        }

        @SafeVarargs
        public final void setSlots(BuiltinIntentSlot ... slots) {
            this.slots(Arrays.asList(slots));
        }

        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        public Builder signature(String var1);

        public Builder supportedLocales(Collection<String> var1);

        public Builder supportedLocales(String ... var1);

        public Builder supportedLocales(Locale ... var1);

        public Builder slots(Collection<BuiltinIntentSlot> var1);

        public Builder slots(BuiltinIntentSlot ... var1);
    }
}

