/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinIntentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBuiltinIntentsResponse> {
    private final List<BuiltinIntentMetadata> intents;
    private final String nextToken;

    private GetBuiltinIntentsResponse(BuilderImpl builder) {
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    public List<BuiltinIntentMetadata> intents() {
        return this.intents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.intents() == null ? 0 : this.intents().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsResponse)) {
            return false;
        }
        GetBuiltinIntentsResponse other = (GetBuiltinIntentsResponse)((Object)obj);
        if (other.intents() == null ^ this.intents() == null) {
            return false;
        }
        if (other.intents() != null && !other.intents().equals(this.intents())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.intents() != null) {
            sb.append("Intents: ").append(this.intents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BuiltinIntentMetadata> intents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsResponse model) {
            this.setIntents(model.intents);
            this.setNextToken(model.nextToken);
        }

        public final Collection<BuiltinIntentMetadata> getIntents() {
            return this.intents;
        }

        @Override
        public final Builder intents(Collection<BuiltinIntentMetadata> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(BuiltinIntentMetadata ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<BuiltinIntentMetadata> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copy(intents);
        }

        @SafeVarargs
        public final void setIntents(BuiltinIntentMetadata ... intents) {
            this.intents(Arrays.asList(intents));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetBuiltinIntentsResponse build() {
            return new GetBuiltinIntentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinIntentsResponse> {
        public Builder intents(Collection<BuiltinIntentMetadata> var1);

        public Builder intents(BuiltinIntentMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

