/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.ProcessBehavior;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBotRequest> {
    private final String name;
    private final String description;
    private final List<Intent> intents;
    private final Prompt clarificationPrompt;
    private final Statement abortStatement;
    private final Integer idleSessionTTLInSeconds;
    private final String voiceId;
    private final String checksum;
    private final String processBehavior;
    private final String locale;
    private final Boolean childDirected;

    private PutBotRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.processBehavior = builder.processBehavior;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Intent> intents() {
        return this.intents;
    }

    public Prompt clarificationPrompt() {
        return this.clarificationPrompt;
    }

    public Statement abortStatement() {
        return this.abortStatement;
    }

    public Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public String voiceId() {
        return this.voiceId;
    }

    public String checksum() {
        return this.checksum;
    }

    public String processBehavior() {
        return this.processBehavior;
    }

    public String locale() {
        return this.locale;
    }

    public Boolean childDirected() {
        return this.childDirected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.intents() == null ? 0 : this.intents().hashCode());
        hashCode = 31 * hashCode + (this.clarificationPrompt() == null ? 0 : this.clarificationPrompt().hashCode());
        hashCode = 31 * hashCode + (this.abortStatement() == null ? 0 : this.abortStatement().hashCode());
        hashCode = 31 * hashCode + (this.idleSessionTTLInSeconds() == null ? 0 : this.idleSessionTTLInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.voiceId() == null ? 0 : this.voiceId().hashCode());
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        hashCode = 31 * hashCode + (this.processBehavior() == null ? 0 : this.processBehavior().hashCode());
        hashCode = 31 * hashCode + (this.locale() == null ? 0 : this.locale().hashCode());
        hashCode = 31 * hashCode + (this.childDirected() == null ? 0 : this.childDirected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotRequest)) {
            return false;
        }
        PutBotRequest other = (PutBotRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.intents() == null ^ this.intents() == null) {
            return false;
        }
        if (other.intents() != null && !other.intents().equals(this.intents())) {
            return false;
        }
        if (other.clarificationPrompt() == null ^ this.clarificationPrompt() == null) {
            return false;
        }
        if (other.clarificationPrompt() != null && !other.clarificationPrompt().equals(this.clarificationPrompt())) {
            return false;
        }
        if (other.abortStatement() == null ^ this.abortStatement() == null) {
            return false;
        }
        if (other.abortStatement() != null && !other.abortStatement().equals(this.abortStatement())) {
            return false;
        }
        if (other.idleSessionTTLInSeconds() == null ^ this.idleSessionTTLInSeconds() == null) {
            return false;
        }
        if (other.idleSessionTTLInSeconds() != null && !other.idleSessionTTLInSeconds().equals(this.idleSessionTTLInSeconds())) {
            return false;
        }
        if (other.voiceId() == null ^ this.voiceId() == null) {
            return false;
        }
        if (other.voiceId() != null && !other.voiceId().equals(this.voiceId())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.processBehavior() == null ^ this.processBehavior() == null) {
            return false;
        }
        if (other.processBehavior() != null && !other.processBehavior().equals(this.processBehavior())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.childDirected() == null ^ this.childDirected() == null) {
            return false;
        }
        return other.childDirected() == null || other.childDirected().equals(this.childDirected());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.intents() != null) {
            sb.append("Intents: ").append(this.intents()).append(",");
        }
        if (this.clarificationPrompt() != null) {
            sb.append("ClarificationPrompt: ").append(this.clarificationPrompt()).append(",");
        }
        if (this.abortStatement() != null) {
            sb.append("AbortStatement: ").append(this.abortStatement()).append(",");
        }
        if (this.idleSessionTTLInSeconds() != null) {
            sb.append("IdleSessionTTLInSeconds: ").append(this.idleSessionTTLInSeconds()).append(",");
        }
        if (this.voiceId() != null) {
            sb.append("VoiceId: ").append(this.voiceId()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.processBehavior() != null) {
            sb.append("ProcessBehavior: ").append(this.processBehavior()).append(",");
        }
        if (this.locale() != null) {
            sb.append("Locale: ").append(this.locale()).append(",");
        }
        if (this.childDirected() != null) {
            sb.append("ChildDirected: ").append(this.childDirected()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Intent> intents;
        private Prompt clarificationPrompt;
        private Statement abortStatement;
        private Integer idleSessionTTLInSeconds;
        private String voiceId;
        private String checksum;
        private String processBehavior;
        private String locale;
        private Boolean childDirected;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotRequest model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setIntents(model.intents);
            this.setClarificationPrompt(model.clarificationPrompt);
            this.setAbortStatement(model.abortStatement);
            this.setIdleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.setVoiceId(model.voiceId);
            this.setChecksum(model.checksum);
            this.setProcessBehavior(model.processBehavior);
            this.setLocale(model.locale);
            this.setChildDirected(model.childDirected);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent> getIntents() {
            return this.intents;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
        }

        @SafeVarargs
        public final void setIntents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
        }

        public final Prompt getClarificationPrompt() {
            return this.clarificationPrompt;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
        }

        public final Statement getAbortStatement() {
            return this.abortStatement;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getProcessBehavior() {
            return this.processBehavior;
        }

        @Override
        public final Builder processBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
            return this;
        }

        @Override
        public final Builder processBehavior(ProcessBehavior processBehavior) {
            this.processBehavior(processBehavior.toString());
            return this;
        }

        public final void setProcessBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
        }

        public final void setProcessBehavior(ProcessBehavior processBehavior) {
            this.processBehavior(processBehavior.toString());
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final void setLocale(Locale locale) {
            this.locale(locale.toString());
        }

        public final Boolean getChildDirected() {
            return this.childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        public PutBotRequest build() {
            return new PutBotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBotRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder intents(Collection<Intent> var1);

        public Builder intents(Intent ... var1);

        public Builder clarificationPrompt(Prompt var1);

        public Builder abortStatement(Statement var1);

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder voiceId(String var1);

        public Builder checksum(String var1);

        public Builder processBehavior(String var1);

        public Builder processBehavior(ProcessBehavior var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder childDirected(Boolean var1);
    }
}

