/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValuesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutSlotTypeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutSlotTypeRequest> {
    private final String name;
    private final String description;
    private final List<EnumerationValue> enumerationValues;
    private final String checksum;

    private PutSlotTypeRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<EnumerationValue> enumerationValues() {
        return this.enumerationValues;
    }

    public String checksum() {
        return this.checksum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.enumerationValues() == null ? 0 : this.enumerationValues().hashCode());
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enumerationValues() == null ^ this.enumerationValues() == null) {
            return false;
        }
        if (other.enumerationValues() != null && !other.enumerationValues().equals(this.enumerationValues())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        return other.checksum() == null || other.checksum().equals(this.checksum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.enumerationValues() != null) {
            sb.append("EnumerationValues: ").append(this.enumerationValues()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<EnumerationValue> enumerationValues;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setEnumerationValues(model.enumerationValues);
            this.setChecksum(model.checksum);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue> getEnumerationValues() {
            return this.enumerationValues;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
        }

        @SafeVarargs
        public final void setEnumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutSlotTypeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enumerationValues(Collection<EnumerationValue> var1);

        public Builder enumerationValues(EnumerationValue ... var1);

        public Builder checksum(String var1);
    }
}

