/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotConstraint;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.SlotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Slot
implements StructuredPojo,
ToCopyableBuilder<Builder, Slot> {
    private final String name;
    private final String description;
    private final String slotConstraint;
    private final String slotType;
    private final String slotTypeVersion;
    private final Prompt valueElicitationPrompt;
    private final Integer priority;
    private final List<String> sampleUtterances;
    private final String responseCard;

    private Slot(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotType = builder.slotType;
        this.slotTypeVersion = builder.slotTypeVersion;
        this.valueElicitationPrompt = builder.valueElicitationPrompt;
        this.priority = builder.priority;
        this.sampleUtterances = builder.sampleUtterances;
        this.responseCard = builder.responseCard;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String slotConstraint() {
        return this.slotConstraint;
    }

    public String slotType() {
        return this.slotType;
    }

    public String slotTypeVersion() {
        return this.slotTypeVersion;
    }

    public Prompt valueElicitationPrompt() {
        return this.valueElicitationPrompt;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public String responseCard() {
        return this.responseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.slotConstraint() == null ? 0 : this.slotConstraint().hashCode());
        hashCode = 31 * hashCode + (this.slotType() == null ? 0 : this.slotType().hashCode());
        hashCode = 31 * hashCode + (this.slotTypeVersion() == null ? 0 : this.slotTypeVersion().hashCode());
        hashCode = 31 * hashCode + (this.valueElicitationPrompt() == null ? 0 : this.valueElicitationPrompt().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.sampleUtterances() == null ? 0 : this.sampleUtterances().hashCode());
        hashCode = 31 * hashCode + (this.responseCard() == null ? 0 : this.responseCard().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.slotConstraint() == null ^ this.slotConstraint() == null) {
            return false;
        }
        if (other.slotConstraint() != null && !other.slotConstraint().equals(this.slotConstraint())) {
            return false;
        }
        if (other.slotType() == null ^ this.slotType() == null) {
            return false;
        }
        if (other.slotType() != null && !other.slotType().equals(this.slotType())) {
            return false;
        }
        if (other.slotTypeVersion() == null ^ this.slotTypeVersion() == null) {
            return false;
        }
        if (other.slotTypeVersion() != null && !other.slotTypeVersion().equals(this.slotTypeVersion())) {
            return false;
        }
        if (other.valueElicitationPrompt() == null ^ this.valueElicitationPrompt() == null) {
            return false;
        }
        if (other.valueElicitationPrompt() != null && !other.valueElicitationPrompt().equals(this.valueElicitationPrompt())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.sampleUtterances() == null ^ this.sampleUtterances() == null) {
            return false;
        }
        if (other.sampleUtterances() != null && !other.sampleUtterances().equals(this.sampleUtterances())) {
            return false;
        }
        if (other.responseCard() == null ^ this.responseCard() == null) {
            return false;
        }
        return other.responseCard() == null || other.responseCard().equals(this.responseCard());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.slotConstraint() != null) {
            sb.append("SlotConstraint: ").append(this.slotConstraint()).append(",");
        }
        if (this.slotType() != null) {
            sb.append("SlotType: ").append(this.slotType()).append(",");
        }
        if (this.slotTypeVersion() != null) {
            sb.append("SlotTypeVersion: ").append(this.slotTypeVersion()).append(",");
        }
        if (this.valueElicitationPrompt() != null) {
            sb.append("ValueElicitationPrompt: ").append(this.valueElicitationPrompt()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.sampleUtterances()).append(",");
        }
        if (this.responseCard() != null) {
            sb.append("ResponseCard: ").append(this.responseCard()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String slotConstraint;
        private String slotType;
        private String slotTypeVersion;
        private Prompt valueElicitationPrompt;
        private Integer priority;
        private List<String> sampleUtterances;
        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setSlotConstraint(model.slotConstraint);
            this.setSlotType(model.slotType);
            this.setSlotTypeVersion(model.slotTypeVersion);
            this.setValueElicitationPrompt(model.valueElicitationPrompt);
            this.setPriority(model.priority);
            this.setSampleUtterances(model.sampleUtterances);
            this.setResponseCard(model.responseCard);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint.toString());
            return this;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        public final void setSlotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint.toString());
        }

        public final String getSlotType() {
            return this.slotType;
        }

        @Override
        public final Builder slotType(String slotType) {
            this.slotType = slotType;
            return this;
        }

        public final void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        public final String getSlotTypeVersion() {
            return this.slotTypeVersion;
        }

        @Override
        public final Builder slotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
            return this;
        }

        public final void setSlotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
        }

        public final Prompt getValueElicitationPrompt() {
            return this.valueElicitationPrompt;
        }

        @Override
        public final Builder valueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
            return this;
        }

        public final void setValueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<String> getSampleUtterances() {
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
        }

        @SafeVarargs
        public final void setSampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
        }

        public final String getResponseCard() {
            return this.responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        public Slot build() {
            return new Slot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Slot> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder slotType(String var1);

        public Builder slotTypeVersion(String var1);

        public Builder valueElicitationPrompt(Prompt var1);

        public Builder priority(Integer var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder responseCard(String var1);
    }
}

