/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Message;
import software.amazon.awssdk.services.lexmodelbuilding.model.MessageListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.StatementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Statement
implements StructuredPojo,
ToCopyableBuilder<Builder, Statement> {
    private final List<Message> messages;
    private final String responseCard;

    private Statement(BuilderImpl builder) {
        this.messages = builder.messages;
        this.responseCard = builder.responseCard;
    }

    public List<Message> messages() {
        return this.messages;
    }

    public String responseCard() {
        return this.responseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        hashCode = 31 * hashCode + (this.responseCard() == null ? 0 : this.responseCard().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        if (other.responseCard() == null ^ this.responseCard() == null) {
            return false;
        }
        return other.responseCard() == null || other.responseCard().equals(this.responseCard());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        if (this.responseCard() != null) {
            sb.append("ResponseCard: ").append(this.responseCard()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Message> messages;
        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.setMessages(model.messages);
            this.setResponseCard(model.responseCard);
        }

        public final Collection<Message> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(Message ... messages) {
            this.messages(Arrays.asList(messages));
        }

        public final String getResponseCard() {
            return this.responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        public Statement build() {
            return new Statement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Statement> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder responseCard(String var1);
    }
}

