/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UtteranceData
implements StructuredPojo,
ToCopyableBuilder<Builder, UtteranceData> {
    private final String utteranceString;
    private final Integer count;
    private final Integer distinctUsers;
    private final Instant firstUtteredDate;
    private final Instant lastUtteredDate;

    private UtteranceData(BuilderImpl builder) {
        this.utteranceString = builder.utteranceString;
        this.count = builder.count;
        this.distinctUsers = builder.distinctUsers;
        this.firstUtteredDate = builder.firstUtteredDate;
        this.lastUtteredDate = builder.lastUtteredDate;
    }

    public String utteranceString() {
        return this.utteranceString;
    }

    public Integer count() {
        return this.count;
    }

    public Integer distinctUsers() {
        return this.distinctUsers;
    }

    public Instant firstUtteredDate() {
        return this.firstUtteredDate;
    }

    public Instant lastUtteredDate() {
        return this.lastUtteredDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.utteranceString() == null ? 0 : this.utteranceString().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.distinctUsers() == null ? 0 : this.distinctUsers().hashCode());
        hashCode = 31 * hashCode + (this.firstUtteredDate() == null ? 0 : this.firstUtteredDate().hashCode());
        hashCode = 31 * hashCode + (this.lastUtteredDate() == null ? 0 : this.lastUtteredDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceData)) {
            return false;
        }
        UtteranceData other = (UtteranceData)obj;
        if (other.utteranceString() == null ^ this.utteranceString() == null) {
            return false;
        }
        if (other.utteranceString() != null && !other.utteranceString().equals(this.utteranceString())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.distinctUsers() == null ^ this.distinctUsers() == null) {
            return false;
        }
        if (other.distinctUsers() != null && !other.distinctUsers().equals(this.distinctUsers())) {
            return false;
        }
        if (other.firstUtteredDate() == null ^ this.firstUtteredDate() == null) {
            return false;
        }
        if (other.firstUtteredDate() != null && !other.firstUtteredDate().equals(this.firstUtteredDate())) {
            return false;
        }
        if (other.lastUtteredDate() == null ^ this.lastUtteredDate() == null) {
            return false;
        }
        return other.lastUtteredDate() == null || other.lastUtteredDate().equals(this.lastUtteredDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.utteranceString() != null) {
            sb.append("UtteranceString: ").append(this.utteranceString()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.distinctUsers() != null) {
            sb.append("DistinctUsers: ").append(this.distinctUsers()).append(",");
        }
        if (this.firstUtteredDate() != null) {
            sb.append("FirstUtteredDate: ").append(this.firstUtteredDate()).append(",");
        }
        if (this.lastUtteredDate() != null) {
            sb.append("LastUtteredDate: ").append(this.lastUtteredDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String utteranceString;
        private Integer count;
        private Integer distinctUsers;
        private Instant firstUtteredDate;
        private Instant lastUtteredDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceData model) {
            this.setUtteranceString(model.utteranceString);
            this.setCount(model.count);
            this.setDistinctUsers(model.distinctUsers);
            this.setFirstUtteredDate(model.firstUtteredDate);
            this.setLastUtteredDate(model.lastUtteredDate);
        }

        public final String getUtteranceString() {
            return this.utteranceString;
        }

        @Override
        public final Builder utteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
            return this;
        }

        public final void setUtteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getDistinctUsers() {
            return this.distinctUsers;
        }

        @Override
        public final Builder distinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
            return this;
        }

        public final void setDistinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
        }

        public final Instant getFirstUtteredDate() {
            return this.firstUtteredDate;
        }

        @Override
        public final Builder firstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
            return this;
        }

        public final void setFirstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
        }

        public final Instant getLastUtteredDate() {
            return this.lastUtteredDate;
        }

        @Override
        public final Builder lastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
            return this;
        }

        public final void setLastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
        }

        public UtteranceData build() {
            return new UtteranceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UtteranceData> {
        public Builder utteranceString(String var1);

        public Builder count(Integer var1);

        public Builder distinctUsers(Integer var1);

        public Builder firstUtteredDate(Instant var1);

        public Builder lastUtteredDate(Instant var1);
    }
}

